/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.file_storage;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.config.register.storage.Node;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;
import org.springframework.beans.factory.annotation.Value;

public class FileStorageOnDisk
implements FileStorage {
    @Value(value="${n2o.config.path}")
    private String basePath;

    @Override
    public void saveFile(String projectId, String file, String source) {
        String fileFolder = this.getProjectPath(projectId) + "/" + file;
        FileSystemUtil.saveContentToFile((String)source, (File)new File(fileFolder));
    }

    @Override
    public String getFileContent(String projectId, String file) {
        String uri = PathUtil.convertRootPathToUrl((String)(this.getProjectPath(projectId) + "/" + file));
        return FileSystemUtil.getContentByUri((String)uri, (boolean)false);
    }

    @Override
    public List<FileModel> getProjectFiles(String projectId) {
        String uri = PathUtil.convertRootPathToUrl((String)this.getProjectPath(projectId));
        return this.findFilesByUri(uri);
    }

    @Override
    public boolean isProjectExists(String projectId) {
        return Paths.get(this.getProjectPath(projectId) + "/index.page.xml", new String[0]).toFile().exists();
    }

    private List<FileModel> findFilesByUri(String uri) {
        ArrayList<FileModel> files = new ArrayList<FileModel>();
        String pattern = PathUtil.convertUrlToPattern((String)uri, (String)"*", (String)"*");
        List nodes = FileSystemUtil.getNodesByLocationPattern((String)pattern);
        for (Node node : nodes) {
            FileModel file = new FileModel().setFile(node.getLocalPath()).setSource(node.retrieveContent());
            if (node.getLocalPath().endsWith("index.page.xml")) {
                files.add(0, file);
                continue;
            }
            files.add(file);
        }
        return files;
    }

    private String getProjectPath(String projectId) {
        return this.basePath + "/" + projectId;
    }
}

