/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.N2oTestDataProvider;
import net.n2oapp.framework.engine.data.json.TestDataProviderEngine;
import net.n2oapp.framework.sandbox.engine.thread_local.ThreadLocalProjectId;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import net.n2oapp.framework.sandbox.utils.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class SandboxTestDataProviderEngine
extends TestDataProviderEngine {
    @Autowired
    private ProjectTemplateHolder templatesHolder;
    @Autowired
    private FileStorage fileStorage;

    protected synchronized List<DataSet> getData(N2oTestDataProvider invocation) {
        boolean isInit;
        if (invocation.getFile() == null) {
            return new ArrayList<DataSet>();
        }
        boolean bl = isInit = this.getRepositoryData(invocation.getFile()) == null;
        if (isInit || !this.isReadonly()) {
            this.initRepository(invocation);
        }
        return (List)this.getRepository().get(this.richKey(invocation.getFile()));
    }

    protected void updateFile(String filename) {
        String projectId = ThreadLocalProjectId.getProjectId();
        try {
            String mapAsJson = super.getObjectMapper().writeValueAsString((Object)this.getRepositoryData(filename));
            this.fileStorage.saveFile(projectId, filename, mapAsJson);
        }
        catch (JsonProcessingException e) {
            throw new N2oException((Throwable)e);
        }
    }

    protected InputStream getResourceInputStream(N2oTestDataProvider invocation) throws IOException {
        try {
            String projectId = ThreadLocalProjectId.getProjectId();
            if (FileUtil.isTemplate(projectId)) {
                TemplateModel templateModel = this.templatesHolder.getTemplateModel(projectId);
                List<FileModel> files = FileUtil.findResources(templateModel.getTemplateId());
                Optional<FileModel> first = files.stream().filter(f -> f.getFile().equals(invocation.getFile())).findFirst();
                if (first.isPresent()) {
                    return new ByteArrayInputStream(first.get().getSource().getBytes());
                }
                throw new FileNotFoundException(invocation.getFile());
            }
            String response = this.fileStorage.getFileContent(projectId, invocation.getFile());
            if (response != null) {
                return new ByteArrayInputStream(response.getBytes());
            }
            throw new FileNotFoundException(invocation.getFile());
        }
        catch (HttpClientErrorException.NotFound e) {
            ClassPathResource classPathResource = new ClassPathResource(invocation.getFile());
            if (classPathResource.exists()) {
                return classPathResource.getInputStream();
            }
            throw new FileNotFoundException(invocation.getFile());
        }
    }

    protected String richKey(String key) {
        String projectId = ThreadLocalProjectId.getProjectId();
        return projectId + "/" + key;
    }
}

