/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.n2oapp.framework.api.rest.ControllerFactory;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.AlertMessagesConstructor;
import net.n2oapp.framework.boot.N2oContextConfiguration;
import net.n2oapp.framework.boot.N2oEngineConfiguration;
import net.n2oapp.framework.boot.N2oEnvironmentConfiguration;
import net.n2oapp.framework.boot.N2oMessagesConfiguration;
import net.n2oapp.framework.boot.N2oMetadataConfiguration;
import net.n2oapp.framework.boot.ObjectMapperConstructor;
import net.n2oapp.framework.sandbox.SandboxAlertMessagesConstructor;
import net.n2oapp.framework.sandbox.WebStaticResolver;
import net.n2oapp.framework.sandbox.engine.SandboxTestDataProviderEngine;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.FileStorageOnDisk;
import net.n2oapp.framework.sandbox.file_storage.S3FileStorage;
import net.n2oapp.framework.sandbox.view.SandboxApplicationBuilderConfigurer;
import net.n2oapp.framework.sandbox.view.SandboxContext;
import net.n2oapp.framework.sandbox.view.SandboxPropertyResolver;
import net.n2oapp.framework.ui.controller.N2oControllerFactory;
import net.n2oapp.framework.ui.controller.action.SetController;
import net.n2oapp.framework.ui.controller.query.GetController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.PropertyResolver;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ResourceResolver;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Configuration
@Import(value={N2oMessagesConfiguration.class, N2oContextConfiguration.class, N2oEnvironmentConfiguration.class, N2oMetadataConfiguration.class, N2oEngineConfiguration.class})
@EnableJpaRepositories
@EnableAutoConfiguration
@EnableCaching
@ComponentScan(basePackages={"net.n2oapp.framework.sandbox", "net.n2oapp.framework.autotest.cases"})
public class N2oSandboxConfiguration {
    @Value(value="${s3.access-key:#{null}}")
    private String accessKey;
    @Value(value="${s3.secret-key:#{null}}")
    private String secretKey;
    @Value(value="${s3.url:#{null}}")
    private String endpoint;
    @Value(value="${s3.bucket:#{null}}")
    private String bucket;

    @Bean
    public ObjectMapper objectMapper() {
        return ObjectMapperConstructor.metaObjectMapper();
    }

    @Bean
    public WebMvcConfigurer mvcConfigurer() {
        return new WebMvcConfigurer(this){

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/view/*/static/**"}).addResourceLocations(new String[]{"/static/"}).resourceChain(true).addResolver((ResourceResolver)new WebStaticResolver("META-INF/resources"));
            }
        };
    }

    @Bean
    public ControllerFactory controllerFactory(Map<String, SetController> setControllers, Map<String, GetController> getControllers) {
        HashMap<String, Object> controllers = new HashMap<String, Object>();
        controllers.putAll(setControllers);
        controllers.putAll(getControllers);
        return new N2oControllerFactory(controllers);
    }

    @Bean
    public PropertyResolver propertyResolver() {
        return new SandboxPropertyResolver();
    }

    @Bean
    public AlertMessageBuilder alertMessageBuilder(@Qualifier(value="n2oMessageSourceAccessor") MessageSourceAccessor messageSourceAccessor, PropertyResolver propertyResolver) {
        return new AlertMessageBuilder(messageSourceAccessor, propertyResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    public AlertMessagesConstructor alertMessagesConstructor(AlertMessageBuilder messageBuilder) {
        return new SandboxAlertMessagesConstructor(messageBuilder);
    }

    @Bean
    public HttpSessionListener httpSessionListener() {
        return new HttpSessionListener(this){
            @Autowired
            private SandboxTestDataProviderEngine dataProviderEngine;
            @Autowired
            private SandboxContext sandboxContext;

            public void sessionDestroyed(HttpSessionEvent se) {
                HttpSession session = se.getSession();
                this.dataProviderEngine.deleteSessionDataSets(session);
                this.sandboxContext.deleteSessionProjectsProperties(session);
            }
        };
    }

    @Bean
    @ConditionalOnProperty(name={"s3.url"})
    public FileStorage s3FileStorage(S3Client s3Client) {
        return new S3FileStorage(s3Client, this.bucket);
    }

    @Bean
    @ConditionalOnProperty(name={"s3.url"})
    public S3Client s3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(URI.create(this.endpoint))).region(Region.of((String)"Stub"))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey)))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public FileStorage fileStorageOnDisk() {
        return new FileStorageOnDisk();
    }

    @Bean
    @ConditionalOnMissingBean
    public SandboxApplicationBuilderConfigurer sandboxApplicationBuilderConfigurer() {
        return new SandboxApplicationBuilderConfigurer();
    }
}

