/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.view;

import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.n2oapp.framework.api.context.ContextEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.sandbox.engine.thread_local.ThreadLocalProjectId;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import net.n2oapp.framework.sandbox.utils.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SandboxContext
implements ContextEngine {
    public static final String USER_PROPERTIES = "user.properties";
    private static final String SESSION_PROJECT_SEPARATOR = "/";
    private final Map<String, Properties> properties = new ConcurrentHashMap<String, Properties>();
    @Autowired
    private FileStorage fileStorage;
    @Autowired
    private HttpSession session;
    @Autowired
    private ProjectTemplateHolder templatesHolder;

    public Object get(String name) {
        String projectId = ThreadLocalProjectId.getProjectId();
        this.properties.computeIfAbsent(projectId, this::createProperties);
        return this.getProperty(name, projectId);
    }

    public void set(Map<String, Object> dataSet) {
        String projectId = ThreadLocalProjectId.getProjectId();
        this.properties.computeIfAbsent(projectId, this::createProperties);
        this.properties.get(projectId).putAll(dataSet);
    }

    public Object get(String param, Map<String, Object> cache) {
        return this.get(param);
    }

    public void set(Map<String, Object> data, Map<String, Object> cache) {
        this.set(data);
    }

    public void refresh() {
        String projectId = ThreadLocalProjectId.getProjectId();
        this.properties.remove(projectId);
    }

    public void deleteSessionProjectsProperties(HttpSession session) {
        for (Map.Entry<String, Properties> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(session.getId() + SESSION_PROJECT_SEPARATOR)) continue;
            this.properties.remove(entry.getKey());
        }
    }

    private Object getProperty(String name, String projectId) {
        String p;
        Object property = this.properties.get(projectId).get(name);
        if (property != null && property.getClass() == String.class && (p = (String)property).startsWith("[") && p.endsWith("]")) {
            return Stream.of(p.substring(1, p.length() - 1).split(",")).map(String::trim).toList();
        }
        return property;
    }

    private Properties createProperties(String projectId) {
        Properties props = new Properties();
        String userProperties = null;
        if (FileUtil.isTemplate(projectId)) {
            TemplateModel templateModel = this.templatesHolder.getTemplateModel(projectId);
            List<FileModel> files = FileUtil.findResources(templateModel.getTemplateId());
            Optional<FileModel> property = files.stream().filter(f -> f.getFile().equals(USER_PROPERTIES)).findFirst();
            if (property.isPresent()) {
                userProperties = property.get().getSource();
            }
        } else {
            userProperties = this.fileStorage.getFileContent(projectId, USER_PROPERTIES);
        }
        if (userProperties != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(userProperties.getBytes());
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                props.load(bufferedReader);
            }
            catch (IOException e) {
                throw new N2oException((Throwable)e);
            }
        }
        return props;
    }
}

