/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.utils;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.n2oapp.framework.config.register.storage.Node;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;

public class FileUtil {
    public static List<FileModel> findResources(String path) {
        String uri = PathUtil.convertPathToClasspathUri((String)path);
        return FileUtil.findFilesByUri(uri);
    }

    public static List<FileModel> findFilesByUri(String uri) {
        ArrayList<FileModel> files = new ArrayList<FileModel>();
        String pattern = PathUtil.convertUrlToPattern((String)uri, (String)"*", (String)"*");
        List nodes = FileSystemUtil.getNodesByLocationPattern((String)pattern);
        for (Node node : nodes) {
            FileModel file = new FileModel().setFile(node.getLocalPath()).setSource(node.retrieveContent());
            if (node.getLocalPath().endsWith("index.page.xml")) {
                files.add(0, file);
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public static boolean isTemplate(String projectId) {
        return projectId.contains("_");
    }

    @Generated
    private FileUtil() {
    }
}

