/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.scanner;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.register.scanner.OverrideInfoScanner;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;
import net.n2oapp.framework.sandbox.scanner.ProjectFileInfo;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import net.n2oapp.framework.sandbox.utils.FileNameUtil;
import net.n2oapp.framework.sandbox.utils.FileUtil;

public class ProjectFileScanner
implements OverrideInfoScanner<ProjectFileInfo> {
    private String projectId;
    private SourceTypeRegister typeRegister;
    private FileStorage fileStorage;
    private ProjectTemplateHolder templatesHolder;

    public ProjectFileScanner(String projectId, SourceTypeRegister typeRegister, FileStorage fileStorage, ProjectTemplateHolder templatesHolder) {
        this.projectId = projectId;
        this.typeRegister = typeRegister;
        this.fileStorage = fileStorage;
        this.templatesHolder = templatesHolder;
    }

    public List<ProjectFileInfo> scan() {
        List<FileModel> files = null;
        TemplateModel templateModel = this.templatesHolder.getTemplateModel(this.projectId);
        files = templateModel == null ? this.fileStorage.getProjectFiles(this.projectId) : FileUtil.findResources(templateModel.getTemplateId());
        ArrayList<ProjectFileInfo> result = new ArrayList<ProjectFileInfo>();
        for (FileModel fm : files) {
            if (!FileNameUtil.isSourceFile(fm.getFile()).booleanValue()) continue;
            Class baseSourceClass = this.typeRegister.get(FileNameUtil.getTypeFromFile(fm.getFile())).getBaseSourceClass();
            String name = FileNameUtil.getNameFromFile(fm.getFile());
            ProjectFileInfo fileInfo = new ProjectFileInfo(name, baseSourceClass);
            fileInfo.setSource(fm.getSource());
            result.add(fileInfo);
        }
        return result;
    }
}

