/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases;

import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.OperationExceptionHandler;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.boot.graphql.N2oGraphQlException;
import net.n2oapp.framework.sandbox.cases.GraphQlUtil;
import org.springframework.stereotype.Component;

@Component
public class SandboxOperationExceptionHandler
implements OperationExceptionHandler {
    public N2oException handle(CompiledObject.Operation o, DataSet data, Exception e) {
        if (e instanceof N2oGraphQlException) {
            N2oGraphQlException graphQlException = (N2oGraphQlException)e;
            return GraphQlUtil.constructErrorMessage(graphQlException);
        }
        if (e instanceof N2oException) {
            N2oException n2oException = (N2oException)e;
            return this.addFailInfo(o, data, n2oException);
        }
        return this.addFailInfo(o, data, new N2oException((Throwable)e));
    }

    private N2oException addFailInfo(CompiledObject.Operation o, DataSet data, N2oException e) {
        if (o.getFailText() != null) {
            e.setUserMessage(StringUtils.resolveLinks((String)o.getFailText(), (Object)data));
        }
        if (o.getFailTitle() != null) {
            e.setUserMessageTitle(StringUtils.resolveLinks((String)o.getFailTitle(), (Object)data));
        }
        return e;
    }
}

