/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.context.ContextEngine;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.application.Application;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.meta.saga.AlertSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.api.register.DynamicMetadataProvider;
import net.n2oapp.framework.api.register.DynamicMetadataProviderFactory;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.route.RouteInfo;
import net.n2oapp.framework.api.register.route.RouteRegister;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.api.rest.ControllerFactory;
import net.n2oapp.framework.api.rest.ExportResponse;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.rest.N2oResponse;
import net.n2oapp.framework.api.rest.SetDataResponse;
import net.n2oapp.framework.api.rest.ValidationDataResponse;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.AlertMessagesConstructor;
import net.n2oapp.framework.api.user.UserContext;
import net.n2oapp.framework.api.util.ExternalFilesLoader;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.compile.pipeline.N2oEnvironment;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.pack.N2oAllIOPack;
import net.n2oapp.framework.config.register.dynamic.N2oDynamicMetadataProviderFactory;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import net.n2oapp.framework.config.selective.reader.ReaderFactoryByMap;
import net.n2oapp.framework.config.util.N2oSubModelsProcessor;
import net.n2oapp.framework.engine.data.N2oOperationProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.migrate.XmlIOVersionMigrator;
import net.n2oapp.framework.sandbox.engine.thread_local.ThreadLocalProjectId;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;
import net.n2oapp.framework.sandbox.resource.XsdSchemaParser;
import net.n2oapp.framework.sandbox.scanner.ProjectFileScanner;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import net.n2oapp.framework.sandbox.utils.FileUtil;
import net.n2oapp.framework.sandbox.view.SandboxAppConfigJsonWriter;
import net.n2oapp.framework.sandbox.view.SandboxApplicationBuilderConfigurer;
import net.n2oapp.framework.sandbox.view.SandboxPropertyResolver;
import net.n2oapp.framework.ui.controller.DataController;
import net.n2oapp.framework.ui.controller.N2oControllerFactory;
import net.n2oapp.framework.ui.controller.action.OperationController;
import net.n2oapp.framework.ui.controller.action.ValidationController;
import net.n2oapp.framework.ui.controller.export.ExportController;
import net.n2oapp.framework.ui.controller.export.format.CsvFileGenerator;
import net.n2oapp.framework.ui.controller.export.format.FileGeneratorFactory;
import net.n2oapp.framework.ui.controller.query.MergeValuesController;
import net.n2oapp.framework.ui.controller.query.QueryController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ViewController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewController.class);
    @Value(value="${n2o.version:unknown}")
    private String n2oVersion;
    @Value(value="${n2o.config.path}")
    private String basePath;
    @Value(value="${spring.messages.basename:messages}")
    private String messageBundleBasename;
    private static final String DEFAULT_APP_ID = "default";
    private static final String DATA_REQUEST_PREFIX = "/n2o/data";
    private final DataProcessingStack dataProcessingStack;
    private final AlertMessageBuilder messageBuilder;
    private final QueryProcessor queryProcessor;
    private final N2oOperationProcessor operationProcessor;
    private final Environment environment;
    private final AlertMessagesConstructor messagesConstructor;
    private final RouteRegister projectRouteRegister;
    private final ContextEngine sandboxContext;
    private final SandboxPropertyResolver propertyResolver;
    private final FileStorage fileStorage;
    private final XsdSchemaParser schemaParser;
    private final ProjectTemplateHolder templatesHolder;
    private final ExternalFilesLoader externalFilesLoader;
    private final InvocationProcessor serviceProvider;
    private final MessageSourceAccessor messageSourceAccessor;
    private final N2oDynamicMetadataProviderFactory dynamicMetadataProviderFactory;
    private final ObjectMapper objectMapper;
    private final DomainProcessor domainProcessor;
    private final List<SandboxApplicationBuilderConfigurer> applicationBuilderConfigurers;
    private final XmlIOVersionMigrator migrator;

    public ViewController(DataProcessingStack dataProcessingStack, AlertMessageBuilder messageBuilder, QueryProcessor queryProcessor, N2oOperationProcessor operationProcessor, Environment environment, AlertMessagesConstructor messagesConstructor, RouteRegister projectRouteRegister, ContextEngine sandboxContext, SandboxPropertyResolver propertyResolver, FileStorage fileStorage, XsdSchemaParser schemaParser, ProjectTemplateHolder templatesHolder, ExternalFilesLoader externalFilesLoader, InvocationProcessor serviceProvider, Optional<Map<String, DynamicMetadataProvider>> providers, ObjectMapper objectMapper, @Qualifier(value="n2oMessageSourceAccessor") MessageSourceAccessor messageSourceAccessor, List<SandboxApplicationBuilderConfigurer> applicationBuilderConfigurers) {
        this.dataProcessingStack = dataProcessingStack;
        this.messageBuilder = messageBuilder;
        this.queryProcessor = queryProcessor;
        this.operationProcessor = operationProcessor;
        this.environment = environment;
        this.messagesConstructor = messagesConstructor;
        this.projectRouteRegister = projectRouteRegister;
        this.sandboxContext = sandboxContext;
        this.propertyResolver = propertyResolver;
        this.fileStorage = fileStorage;
        this.schemaParser = schemaParser;
        this.templatesHolder = templatesHolder;
        this.externalFilesLoader = externalFilesLoader;
        this.serviceProvider = serviceProvider;
        this.dynamicMetadataProviderFactory = new N2oDynamicMetadataProviderFactory(providers.orElse(Collections.emptyMap()));
        this.objectMapper = objectMapper;
        this.domainProcessor = new DomainProcessor(objectMapper);
        this.messageSourceAccessor = messageSourceAccessor;
        this.applicationBuilderConfigurers = applicationBuilderConfigurers;
        N2oApplicationBuilder builder = new N2oApplicationBuilder((MetadataEnvironment)new N2oEnvironment());
        builder.packs(new MetadataPack[]{new N2oAllIOPack()});
        this.migrator = new XmlIOVersionMigrator(builder);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/n2o/version", "/n2o/version/"})
    public String getVersion() {
        return this.n2oVersion;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/n2o/templates/{fileName}", "/n2o/templates/{fileName}/"})
    public String getTemplateFile(@PathVariable String fileName) {
        return this.getTemplate(fileName);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/n2o/schemas", "/n2o/schemas/"})
    public ResponseEntity<Resource> loadSchema(@RequestParam(name="name") String schemaNamespace) throws IOException {
        Resource schema = this.schemaParser.getSchema(schemaNamespace);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"filename=\"" + schema.getFilename() + "\""})).body((Object)schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/view/{projectId}/n2o/config", "/view/{projectId}/n2o/config/"})
    public Map<String, Object> getConfig(@PathVariable(value="projectId") String projectId) {
        HashMap<String, Object> addedValues = new HashMap<String, Object>();
        addedValues.put("project", projectId);
        try {
            ThreadLocalProjectId.setProjectId(projectId);
            this.projectRouteRegister.clearAll();
            N2oApplicationBuilder builder = this.getBuilder(projectId);
            addedValues.put("menu", this.getMenu(builder));
            SandboxAppConfigJsonWriter appConfigJsonWriter = new SandboxAppConfigJsonWriter(projectId, this.fileStorage);
            appConfigJsonWriter.setPropertyResolver(builder.getEnvironment().getSystemProperties());
            appConfigJsonWriter.setContextProcessor(builder.getEnvironment().getContextProcessor());
            appConfigJsonWriter.build();
            Map map = appConfigJsonWriter.getValues(addedValues);
            return map;
        }
        finally {
            this.sandboxContext.refresh();
            ThreadLocalProjectId.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/view/{projectId}/n2o/page/**", "/view/{projectId}/n2o/page", "/view/{projectId}/n2o/page/"})
    public Page getPage(@PathVariable(value="projectId") String projectId, HttpServletRequest request) {
        try {
            ThreadLocalProjectId.setProjectId(projectId);
            this.projectRouteRegister.clearAll();
            N2oApplicationBuilder builder = this.getBuilder(projectId);
            this.getIndex(builder);
            this.getMenu(builder);
            String path = this.getPath(request, "/n2o/page");
            CompileContext context = builder.route(path, Page.class, request.getParameterMap());
            N2oSubModelsProcessor n2oSubModelsProcessor = new N2oSubModelsProcessor(this.queryProcessor, this.domainProcessor);
            n2oSubModelsProcessor.setEnvironment(builder.getEnvironment());
            Page page = (Page)((ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)builder.read().transform()).validate()).compile()).transform()).bind()).get(context, context.getParams(path, request.getParameterMap()), (SubModelsProcessor)n2oSubModelsProcessor);
            return page;
        }
        finally {
            this.sandboxContext.refresh();
            ThreadLocalProjectId.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/view/{projectId}/n2o/export/**", "/view/{projectId}/n2o/export", "/view/{projectId}/n2o/export/"})
    public ResponseEntity<byte[]> export(@PathVariable(value="projectId") String projectId, HttpServletRequest request) {
        try {
            ThreadLocalProjectId.setProjectId(projectId);
            N2oApplicationBuilder builder = this.getBuilder(projectId);
            this.getIndex(builder);
            this.getMenu(builder);
            DataController dataController = new DataController(this.createControllerFactory(builder.getEnvironment()), builder.getEnvironment());
            FileGeneratorFactory fileGeneratorFactory = new FileGeneratorFactory(List.of(new CsvFileGenerator()));
            ExportController exportController = new ExportController(builder.getEnvironment(), dataController, fileGeneratorFactory);
            String url = request.getParameter("url");
            String format = request.getParameter("format");
            String charset = request.getParameter("charset");
            String dataPrefix = DATA_REQUEST_PREFIX;
            String path = RouteUtil.parsePath((String)url.substring(url.indexOf(dataPrefix) + dataPrefix.length()));
            Map params = RouteUtil.parseQueryParams((String)RouteUtil.parseQuery((String)url));
            if (params == null) {
                throw new N2oException("Query-\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0443\u0441\u0442\u043e\u0439");
            }
            GetDataResponse dataResponse = exportController.getData(path, params, new UserContext(this.sandboxContext));
            Map headers = exportController.getHeaders(path, params);
            ExportResponse exportResponse = exportController.export(dataResponse.getList(), format, charset, headers);
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((int)exportResponse.getStatus()).contentLength((long)exportResponse.getContentLength()).header("Content-Type", new String[]{exportResponse.getContentType()})).header("Content-Disposition", new String[]{exportResponse.getContentDisposition()})).header("Content-Encoding", new String[]{exportResponse.getCharacterEncoding()})).body((Object)exportResponse.getFile());
            return responseEntity;
        }
        finally {
            this.sandboxContext.refresh();
            ThreadLocalProjectId.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/view/{projectId}/n2o/data/**", "/view/{projectId}/n2o/data", "/view/{projectId}/n2o/data/"})
    public ResponseEntity<GetDataResponse> getData(@PathVariable(value="projectId") String projectId, HttpServletRequest request) {
        try {
            ThreadLocalProjectId.setProjectId(projectId);
            N2oApplicationBuilder builder = this.getBuilder(projectId);
            this.getIndex(builder);
            this.getMenu(builder);
            String path = this.getPath(request, DATA_REQUEST_PREFIX);
            DataController dataController = new DataController(this.createControllerFactory(builder.getEnvironment()), builder.getEnvironment());
            GetDataResponse response = dataController.getData(path, request.getParameterMap(), new UserContext(this.sandboxContext));
            ResponseEntity responseEntity = ResponseEntity.status((int)response.getStatus()).body((Object)response);
            return responseEntity;
        }
        finally {
            this.sandboxContext.refresh();
            ThreadLocalProjectId.clear();
        }
    }

    @CrossOrigin(origins={"*"})
    @PutMapping(value={"/view/{projectId}/n2o/data/**", "/view/{projectId}/n2o/data", "/view/{projectId}/n2o/data/"})
    public ResponseEntity<SetDataResponse> putData(@PathVariable(value="projectId") String projectId, @RequestBody Object body, HttpServletRequest request) {
        return this.setData(projectId, body, request);
    }

    @CrossOrigin(origins={"*"})
    @DeleteMapping(value={"/view/{projectId}/n2o/data/**", "/view/{projectId}/n2o/data", "/view/{projectId}/n2o/data/"})
    public ResponseEntity<SetDataResponse> deleteData(@PathVariable(value="projectId") String projectId, @RequestBody Object body, HttpServletRequest request) {
        return this.setData(projectId, body, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin(origins={"*"})
    @PostMapping(value={"/view/{projectId}/n2o/data/**", "/view/{projectId}/n2o/data", "/view/{projectId}/n2o/data/"})
    public ResponseEntity<SetDataResponse> setData(@PathVariable(value="projectId") String projectId, @RequestBody Object body, HttpServletRequest request) {
        try {
            ThreadLocalProjectId.setProjectId(projectId);
            N2oApplicationBuilder builder = this.getBuilder(projectId);
            this.getIndex(builder);
            this.getMenu(builder);
            String path = this.getPath(request, DATA_REQUEST_PREFIX);
            DataController dataController = new DataController(this.createControllerFactory(builder.getEnvironment()), builder.getEnvironment());
            dataController.setMessageBuilder(this.messageBuilder);
            SetDataResponse dataResponse = dataController.setData(path, request.getParameterMap(), this.getHeaders(request), (Object)this.getBody(body), new UserContext(this.sandboxContext));
            ResponseEntity responseEntity = ResponseEntity.status((int)dataResponse.getStatus()).body((Object)dataResponse);
            return responseEntity;
        }
        finally {
            this.sandboxContext.refresh();
            ThreadLocalProjectId.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CrossOrigin(origins={"*"})
    @PostMapping(path={"/view/{projectId}/n2o/validation/**", "/view/{projectId}/n2o/validation", "/view/{projectId}/n2o/validation/"})
    public ResponseEntity<ValidationDataResponse> validateData(@PathVariable(value="projectId") String projectId, @RequestBody Object body, HttpServletRequest request) {
        try {
            ThreadLocalProjectId.setProjectId(projectId);
            N2oApplicationBuilder builder = this.getBuilder(projectId);
            this.getIndex(builder);
            this.getMenu(builder);
            String path = this.getPath(request, "/n2o/validation");
            DataController dataController = new DataController(this.createControllerFactory(builder.getEnvironment()), builder.getEnvironment());
            dataController.setMessageBuilder(this.messageBuilder);
            ValidationDataResponse dataResponse = dataController.validateData(path, (Object)this.getBody(body));
            ResponseEntity responseEntity = ResponseEntity.status((int)dataResponse.getStatus()).body((Object)dataResponse);
            return responseEntity;
        }
        finally {
            this.sandboxContext.refresh();
            ThreadLocalProjectId.clear();
        }
    }

    @CrossOrigin(origins={"*"})
    @PostMapping(value={"/n2o/migrate"})
    public String migrate(@RequestBody String oldXml) {
        return this.migrator.migrate(oldXml);
    }

    @ExceptionHandler(value={N2oException.class})
    public ResponseEntity<N2oResponse> sendErrorMessage(N2oException e) {
        return ResponseEntity.status((int)e.getHttpStatus()).body((Object)this.initErrorDataResponse((Exception)e));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<N2oResponse> sendErrorMessage(Exception e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.initErrorDataResponse(e));
    }

    private N2oResponse initErrorDataResponse(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        MetaSaga meta = new MetaSaga();
        meta.setAlert(new AlertSaga());
        meta.getAlert().setMessages(this.messagesConstructor.constructMessages(e));
        N2oResponse dataResponse = new N2oResponse();
        dataResponse.setMeta(meta);
        return dataResponse;
    }

    private String getTemplate(String fileName) {
        FileModel fileModel;
        String type = this.getFileType(fileName);
        if (type != null && (fileModel = (FileModel)FileUtil.findFilesByUri("/templates").stream().filter(f -> type.equals(f.getFile())).findFirst().orElse(null)) != null) {
            return fileModel.getSource();
        }
        return "";
    }

    private String getFileType(String fileName) {
        String[] spl = fileName.toLowerCase().split("\\.");
        if (spl.length > 2 && "xml".equals(spl[spl.length - 1])) {
            return spl[spl.length - 2] + "." + spl[spl.length - 1];
        }
        return null;
    }

    private Map<String, Object> getMenu(N2oApplicationBuilder builder) {
        return (Map)this.objectMapper.convertValue((Object)this.getApplication(builder), Map.class);
    }

    private Application getApplication(N2oApplicationBuilder builder) {
        String applicationId = builder.getEnvironment().getSystemProperties().getProperty("n2o.application.id");
        if (DEFAULT_APP_ID.equals(applicationId)) {
            Optional<SourceInfo> applicationInfo = builder.getEnvironment().getMetadataRegister().find(N2oApplication.class).stream().filter(a -> !a.getId().equals(DEFAULT_APP_ID)).findFirst();
            applicationId = applicationInfo.isPresent() ? applicationInfo.get().getId() : DEFAULT_APP_ID;
        }
        return (Application)((ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)builder.read().transform()).validate()).compile()).transform()).bind()).get((CompileContext)new ApplicationContext(applicationId), new DataSet());
    }

    private DataSet getBody(Object body) {
        if (body instanceof Map) {
            return new DataSet((Map)body);
        }
        DataSet dataSet = new DataSet("$list", body);
        dataSet.put("$count", (Object)(body != null ? ((List)body).size() : 0));
        return dataSet;
    }

    private N2oApplicationBuilder getBuilder(@PathVariable(value="projectId") String projectId) {
        N2oEnvironment env = this.createEnvironment(projectId);
        N2oApplicationBuilder builder = new N2oApplicationBuilder((MetadataEnvironment)env);
        this.applicationBuilderConfigurers.forEach(configurer -> configurer.configure(builder));
        builder.scanners(new MetadataScanner[]{new ProjectFileScanner(projectId, builder.getEnvironment().getSourceTypeRegister(), this.fileStorage, this.templatesHolder)});
        return builder.scan();
    }

    private void getIndex(N2oApplicationBuilder builder) {
        PageContext index = new PageContext(this.propertyResolver.getProperty("n2o.homepage.id"), "/");
        builder.routes(new RouteInfo[]{new RouteInfo("/", (CompileContext)index)});
    }

    private String getPath(HttpServletRequest request, String prefix) {
        String path = request.getRequestURI().substring(request.getRequestURI().indexOf(prefix) + prefix.length());
        return RouteUtil.normalize((String)(!path.isEmpty() ? path : "/"));
    }

    private String getAccessFilename(String projectId, TemplateModel templateModel) {
        String format = ".access.xml";
        if (templateModel == null) {
            List<FileModel> projectFiles = this.fileStorage.getProjectFiles(projectId);
            if (projectFiles != null) {
                return this.getFirstFilenameByFormat(format, projectFiles);
            }
        } else {
            List<FileModel> files = FileUtil.findResources(templateModel.getTemplateId());
            return this.getFirstFilenameByFormat(format, files);
        }
        return null;
    }

    private String getFirstFilenameByFormat(String format, List<FileModel> files) {
        Optional<String> first = files.stream().map(FileModel::getFile).filter(name -> name.endsWith(format)).findFirst();
        if (first.isPresent()) {
            String filename = first.get();
            return filename.substring(0, filename.length() - format.length());
        }
        return null;
    }

    private String getApplicationProperties(String projectId, TemplateModel templateModel) {
        String filename = "application.properties";
        if (templateModel == null) {
            return this.fileStorage.getFileContent(projectId, filename);
        }
        List<FileModel> files = FileUtil.findResources(templateModel.getTemplateId());
        Optional<FileModel> first = files.stream().filter(f -> f.getFile().equals(filename)).findFirst();
        return first.map(FileModel::getSource).orElse(null);
    }

    private N2oEnvironment createEnvironment(String projectId) {
        N2oEnvironment env = new N2oEnvironment();
        String path = this.basePath + "/" + projectId;
        TemplateModel templateModel = this.templatesHolder.getTemplateModel(projectId);
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        runtimeProperties.put("n2o.access.schema.id", this.getAccessFilename(projectId, templateModel));
        this.configurePropertyResolver(runtimeProperties, this.getApplicationProperties(projectId, templateModel));
        env.setSystemProperties((PropertyResolver)this.propertyResolver);
        env.setMessageSource(this.getMessageSourceAccessor(path));
        env.setContextProcessor(new ContextProcessor((Context)this.sandboxContext));
        ReaderFactoryByMap readerFactory = new ReaderFactoryByMap((MetadataEnvironment)env);
        env.setNamespaceReaderFactory((NamespaceReaderFactory)readerFactory);
        PersisterFactoryByMap persisterFactory = new PersisterFactoryByMap();
        env.setNamespacePersisterFactory((NamespacePersisterFactory)persisterFactory);
        IOProcessorImpl persistProcessor = new IOProcessorImpl((NamespacePersisterFactory)persisterFactory);
        persistProcessor.setSystemProperties(env.getSystemProperties());
        env.setReadPipelineFunction(p -> (ReadTerminalPipeline)((ReadTerminalPipeline)p.read().transform()).validate());
        env.setReadCompilePipelineFunction(p -> (ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)p.read().transform()).validate()).compile()).transform());
        env.setReadCompileBindTerminalPipelineFunction(p -> (ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)p.read().transform()).validate()).compile()).transform()).bind());
        env.setDynamicMetadataProviderFactory((DynamicMetadataProviderFactory)this.dynamicMetadataProviderFactory);
        env.setRouteRegister(this.projectRouteRegister);
        env.setExternalFilesLoader(this.externalFilesLoader);
        return env;
    }

    private void configurePropertyResolver(Map<String, String> runtimeProperties, String applicationPropertyFile) {
        this.propertyResolver.configure((PropertyResolver)this.environment, runtimeProperties, applicationPropertyFile);
    }

    private ControllerFactory createControllerFactory(MetadataEnvironment environment) {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        N2oSubModelsProcessor subModelsProcessor = new N2oSubModelsProcessor(this.queryProcessor, this.domainProcessor);
        subModelsProcessor.setEnvironment(environment);
        beans.put("queryController", new QueryController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder, this.messagesConstructor));
        beans.put("operationController", new OperationController(this.dataProcessingStack, this.operationProcessor, this.messageBuilder, this.messagesConstructor));
        beans.put("validationController", new ValidationController(this.serviceProvider, this.domainProcessor));
        beans.put("mergeValuesController", new MergeValuesController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder));
        return new N2oControllerFactory(beans);
    }

    private MessageSourceAccessor getMessageSourceAccessor(String projectPath) {
        URLClassLoader loader;
        File projectFolder = new File(projectPath);
        try {
            File[] messageFiles = projectFolder.listFiles(f -> f.getName().contains("messages") && f.getName().endsWith("properties"));
            if (messageFiles == null || messageFiles.length < 1) {
                return this.messageSourceAccessor;
            }
            loader = new URLClassLoader(new URL[]{projectFolder.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            return this.messageSourceAccessor;
        }
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBundleClassLoader((ClassLoader)loader);
        messageSource.setBasenames(this.messageBundleBasename.split(","));
        messageSource.setDefaultEncoding("UTF-8");
        return new MessageSourceAccessor((MessageSource)messageSource);
    }

    private Map<String, String[]> getHeaders(HttpServletRequest req) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Enumeration iter = req.getHeaderNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            result.put(name, new String[]{req.getHeader(name)});
        }
        return result;
    }
}

