/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.view;

import net.n2oapp.cache.template.CacheTemplate;
import net.n2oapp.framework.api.event.N2oEventListener;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.storage.Node;
import net.n2oapp.framework.sandbox.view.ProjectFileUpdateEvent;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class ProjectFileUpdateListener
implements N2oEventListener<ProjectFileUpdateEvent> {
    @Value(value="${n2o.config.path}")
    private String basePath;
    private final SourceTypeRegister sourceTypeRegister;
    private final CacheTemplate<String, SourceMetadata> cacheTemplate;

    public ProjectFileUpdateListener(SourceTypeRegister sourceTypeRegister, CacheManager cacheManager) {
        this.sourceTypeRegister = sourceTypeRegister;
        this.cacheTemplate = new CacheTemplate(cacheManager);
    }

    public void handleEvent(ProjectFileUpdateEvent projectFileUpdateEvent) {
        CacheManager cacheManager = this.cacheTemplate.getCacheManager();
        if (cacheManager == null) {
            return;
        }
        Cache cache = cacheManager.getCache("n2o.source");
        if (cache == null) {
            return;
        }
        InfoConstructor sourceInfo = RegisterUtil.createFolderInfo((Node)Node.byAbsolutePath((String)projectFileUpdateEvent.getFileName(), (String)this.basePath), (SourceTypeRegister)this.sourceTypeRegister);
        cache.evict((Object)this.getKey(projectFileUpdateEvent.getProjectId(), sourceInfo.getId(), sourceInfo.getBaseSourceClass()));
    }

    private String getKey(String projectId, String id, Class<? extends SourceMetadata> sourceClass) {
        return projectId + "." + id + "." + sourceClass.getSimpleName();
    }
}

