/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases.fileupload;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.n2oapp.framework.sandbox.cases.fileupload.FileModel;
import net.n2oapp.framework.sandbox.cases.fileupload.FileStorageController;
import net.n2oapp.framework.sandbox.cases.fileupload.PersonModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

@Component
public class PersonStorageController {
    private final Map<String, PersonModel> storage = new HashMap<String, PersonModel>();
    private final FileStorageController fileStorageController;
    private int id = 0;

    public PersonStorageController(@Autowired FileStorageController fileStorageController) {
        this.fileStorageController = fileStorageController;
        PersonModel personModel = new PersonModel("" + this.id++, "Ivanov", "Ivan", "Ivanovich", null);
        this.storage.put(personModel.getId(), personModel);
    }

    public ListResponse getList() {
        return new ListResponse(this.storage.values());
    }

    public PersonModel getById(@PathVariable String id) {
        return this.storage.get(id);
    }

    public String createPerson(@RequestBody PersonModel person) {
        person.setId("" + this.id++);
        this.storage.put(person.getId(), person);
        return person.getId();
    }

    public void updatePerson(@RequestBody PersonModel person) {
        PersonModel personModel = this.storage.get(person.getId());
        personModel.setName(person.getName());
        personModel.setSurname(person.getSurname());
        personModel.setPatronymic(person.getPatronymic());
    }

    public void deletePerson(@PathVariable String id) {
        this.storage.remove(id);
    }

    public void setDoc(String personId, FileModel doc) {
        if (this.storage.get(personId).getFiles() == null) {
            this.storage.get(personId).setFiles(new HashMap<String, FileModel>());
        }
        this.storage.get(personId).getFiles().put(doc.getId(), doc);
    }

    public void deleteDoc(String personId, String id) {
        this.fileStorageController.delete(id);
        this.storage.get(personId).getFiles().remove(id);
    }

    public FileModel storeFile(MultipartFile file, String url) {
        return this.fileStorageController.storeFile(file, url);
    }

    public Resource loadFile(String fileName) {
        return this.fileStorageController.loadFile(fileName);
    }

    static class ListResponse {
        @JsonProperty
        final Collection<PersonModel> persons;

        @Generated
        public Collection<PersonModel> getPersons() {
            return this.persons;
        }

        @Generated
        public ListResponse(Collection<PersonModel> persons) {
            this.persons = persons;
        }
    }
}

