/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases.fileupload;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.n2oapp.framework.sandbox.cases.fileupload.FileModel;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class FileStorageController {
    @Generated
    private final Object $lock = new Object[0];
    private final Path path;
    private static final String DEFAULT_STORE_KEY = "common";
    private final Map<String, Map<String, FileModel>> storage = new HashMap<String, Map<String, FileModel>>();
    private int id = 0;

    public FileStorageController() throws IOException {
        this.path = Files.createTempDirectory("upload", new FileAttribute[0]);
        this.path.toFile().deleteOnExit();
        this.storage.put(DEFAULT_STORE_KEY, new HashMap());
    }

    public ListResponse getList() {
        return this.getList(DEFAULT_STORE_KEY);
    }

    public ListResponse getList(String storeKey) {
        Map<String, FileModel> filesMap = this.storage.get(this.getStoreKeyOrDefault(storeKey));
        return new ListResponse(filesMap == null ? new ArrayList() : filesMap.values());
    }

    public void delete(String id) {
        this.delete(id, DEFAULT_STORE_KEY);
    }

    public void delete(String id, String storeKey) {
        FileModel model;
        if (id == null) {
            return;
        }
        if (storeKey == null) {
            Optional<Map.Entry> storeWithFile = this.storage.entrySet().stream().filter(k -> ((Map)k.getValue()).containsKey(id)).findFirst();
            if (storeWithFile.isEmpty()) {
                return;
            }
            storeKey = (String)storeWithFile.get().getKey();
        }
        if ((model = this.storage.get(storeKey).remove(id)) == null) {
            return;
        }
        try {
            Path filePath = this.getFilePath(model.getFileName(), storeKey).normalize();
            Files.deleteIfExists(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileModel storeFile(MultipartFile file, String url) {
        return this.storeFile(file, url, DEFAULT_STORE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileModel storeFile(MultipartFile file, String url, String storeKey) {
        Object object = this.$lock;
        synchronized (object) {
            try {
                String currentStoreKey = this.getStoreKeyOrDefault(storeKey);
                Path storePath = this.path.resolve(currentStoreKey);
                if (!storePath.toFile().exists()) {
                    Files.createDirectory(storePath, new FileAttribute[0]);
                }
                String fileName = StringUtils.cleanPath((String)file.getOriginalFilename());
                Path targetLocation = this.getFilePath(fileName, currentStoreKey);
                Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
                targetLocation.toFile().deleteOnExit();
                String uri = UriComponentsBuilder.fromPath((String)fileName).toUriString();
                FileModel model = new FileModel("" + ++this.id, fileName, url + "/" + uri, file.getSize(), LocalDateTime.now());
                this.storage.computeIfAbsent(currentStoreKey, k -> new HashMap());
                this.storage.get(currentStoreKey).put("" + this.id, model);
                return model;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public Resource loadFile(String fileName) {
        return this.loadFile(fileName, DEFAULT_STORE_KEY);
    }

    public Resource loadFile(String fileName, String storeKey) {
        try {
            Path filePath = this.getFilePath(fileName, this.getStoreKeyOrDefault(storeKey)).normalize();
            UrlResource resource = new UrlResource(filePath.toUri());
            return resource.exists() ? resource : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.$lock;
        synchronized (object) {
            this.storage.forEach((k, v) -> this.delete((String)k));
        }
    }

    private String getStoreKeyOrDefault(String storeKey) {
        return storeKey == null ? DEFAULT_STORE_KEY : storeKey;
    }

    private Path getFilePath(String fileName, String storeKey) {
        return this.path.resolve(storeKey).resolve(fileName);
    }

    static class ListResponse {
        @JsonProperty
        final Collection<FileModel> files;

        @Generated
        public Collection<FileModel> getFiles() {
            return this.files;
        }

        @Generated
        public ListResponse(Collection<FileModel> files) {
            this.files = files;
        }
    }
}

