/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class WebStaticResolver
implements ResourceResolver {
    private String baseLocation;

    public WebStaticResolver(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public Resource resolveResource(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return new ClassPathResource(this.baseLocation + WebStaticResolver.removeProjectPathVariable(requestPath));
    }

    public String resolveUrlPath(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return WebStaticResolver.removeProjectPathVariable(resourcePath);
    }

    private static String removeProjectPathVariable(String requestPath) {
        return requestPath.substring(requestPath.indexOf(47));
    }
}

