/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.view;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.config.test.SimplePropertyResolver;
import net.n2oapp.framework.sandbox.view.MutablePropertyResolver;
import org.springframework.core.env.PropertyResolver;

public class SandboxPropertyResolver
implements PropertyResolver {
    private PropertyResolver defaultPropertyResolver;
    private PropertyResolver runtimePropertyResolver;
    private PropertyResolver projectPropertyResolver;

    public void configure(PropertyResolver defaultPropertyResolver, Map<String, String> runtimeProperties, String projectFile) {
        this.initResolvers(defaultPropertyResolver, runtimeProperties);
        Properties properties = new Properties();
        if (projectFile != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(projectFile.getBytes());){
                properties.load(inputStream);
            }
            catch (IOException e) {
                throw new N2oException((Throwable)e);
            }
        }
        this.projectPropertyResolver = new SimplePropertyResolver(properties);
    }

    private void initResolvers(PropertyResolver defaultPropertyResolver, Map<String, String> runtimeProperties) {
        this.defaultPropertyResolver = defaultPropertyResolver;
        if (runtimeProperties != null) {
            this.runtimePropertyResolver = new MutablePropertyResolver(runtimeProperties);
        }
    }

    public boolean containsProperty(String key) {
        return this.projectPropertyResolver != null && this.projectPropertyResolver.containsProperty(key) || this.runtimePropertyResolver != null && this.runtimePropertyResolver.containsProperty(key) || this.defaultPropertyResolver != null && this.defaultPropertyResolver.containsProperty(key);
    }

    public String getProperty(String key) {
        String value = this.resolveProperty(key, null, this.projectPropertyResolver, String.class);
        value = this.resolveProperty(key, value, this.runtimePropertyResolver, String.class);
        return this.resolveProperty(key, value, this.defaultPropertyResolver, String.class);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.resolveProperty(key, null, this.projectPropertyResolver, String.class);
        value = this.resolveProperty(key, value, this.runtimePropertyResolver, String.class);
        return (value = this.resolveProperty(key, value, this.defaultPropertyResolver, String.class)) != null ? value : defaultValue;
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        T value = this.resolveProperty(key, null, this.projectPropertyResolver, targetType);
        value = this.resolveProperty(key, value, this.runtimePropertyResolver, targetType);
        return this.resolveProperty(key, value, this.defaultPropertyResolver, targetType);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        T value = this.resolveProperty(key, null, this.projectPropertyResolver, targetType);
        value = this.resolveProperty(key, value, this.runtimePropertyResolver, targetType);
        return (value = this.resolveProperty(key, value, this.defaultPropertyResolver, targetType)) != null ? value : (T)defaultValue;
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        return value == null ? this.defaultPropertyResolver.getRequiredProperty(key) : value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        return (T)(value == null ? this.defaultPropertyResolver.getRequiredProperty(key, targetType) : value);
    }

    public String resolvePlaceholders(String text) {
        String value = text;
        if (this.projectPropertyResolver != null) {
            value = this.projectPropertyResolver.resolvePlaceholders(text);
        }
        if (value.equals(text) && this.runtimePropertyResolver != null) {
            value = this.runtimePropertyResolver.resolvePlaceholders(text);
        }
        if (value.equals(text) && this.defaultPropertyResolver != null) {
            value = this.defaultPropertyResolver.resolvePlaceholders(text);
        }
        return value;
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        String value = this.resolvePlaceholders(text);
        return value.equals(text) ? this.defaultPropertyResolver.resolveRequiredPlaceholders(text) : value;
    }

    private <T> T resolveProperty(String key, T prevValue, PropertyResolver resolver, Class<T> targetType) {
        if (prevValue != null) {
            return prevValue;
        }
        if (resolver != null && resolver.containsProperty(key)) {
            String value = resolver.getProperty(key);
            if (value != null && targetType != null && !String.class.equals(targetType)) {
                if (List.class.equals(targetType)) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (String item : value.split(",")) {
                        list.add(item.trim());
                    }
                    return (T)list;
                }
                if (Set.class.equals(targetType)) {
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (String item : value.split(",")) {
                        set.add(item.trim());
                    }
                    return (T)set;
                }
                if (Boolean.class.equals(targetType)) {
                    return (T)Boolean.valueOf(value);
                }
                if (Integer.class.equals(targetType)) {
                    return (T)Integer.valueOf(value);
                }
                if (Long.class.equals(targetType)) {
                    return (T)Long.valueOf(value);
                }
                if (targetType.isEnum()) {
                    return Enum.valueOf(targetType, value);
                }
                throw new UnsupportedOperationException("targetType " + String.valueOf(targetType) + " is not supported");
            }
            return (T)value;
        }
        return null;
    }
}

