/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.view;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ResponseStatusException;

@Controller
public class IndexPageHandler {
    @Value(value="${server.servlet.context-path:/}")
    private String servletContext;
    private final FileStorage fileStorage;
    private final ProjectTemplateHolder templatesHolder;
    private static final String RELATIVE_PATH = "./";
    private static final String HREF_PATTERN = "href=\"";
    private static final String SRC_PATTERN = "src=\"";
    private static final String VIEW_INDEX_HTML = "META-INF/resources/index.html";

    public IndexPageHandler(FileStorage fileStorage, ProjectTemplateHolder templatesHolder) {
        this.fileStorage = fileStorage;
        this.templatesHolder = templatesHolder;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/view/{projectId}/", "/view/{projectId}"})
    public ResponseEntity<Resource> getIndex(@PathVariable(value="projectId") String projectId) {
        TemplateModel templateModel = this.templatesHolder.getTemplateModel(projectId);
        if (templateModel == null && !this.fileStorage.isProjectExists(projectId)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Project " + projectId + " not found");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_HTML).cacheControl(CacheControl.noCache())).body((Object)this.processHtml());
    }

    private ByteArrayResource processHtml() {
        ByteArrayResource byteArrayResource;
        block9: {
            InputStream io = new ClassPathResource(VIEW_INDEX_HTML).getInputStream();
            try {
                String html = IOUtils.toString((InputStream)io, (Charset)StandardCharsets.UTF_8);
                String rp = RELATIVE_PATH;
                if (!this.servletContext.endsWith("/")) {
                    this.servletContext = this.servletContext + "/";
                }
                html = html.replace(HREF_PATTERN + rp, HREF_PATTERN + this.servletContext).replace(SRC_PATTERN + rp, SRC_PATTERN + this.servletContext).replace(rp + "serviceWorker.js", this.servletContext + "serviceWorker.js");
                byteArrayResource = new ByteArrayResource(html.getBytes(StandardCharsets.UTF_8));
                if (io == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (io != null) {
                        try {
                            io.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            }
            io.close();
        }
        return byteArrayResource;
    }
}

