/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.templates;

import java.util.List;
import net.n2oapp.framework.sandbox.file_storage.model.ProjectModel;
import net.n2oapp.framework.sandbox.templates.CategoryModel;
import net.n2oapp.framework.sandbox.templates.ProjectSearcher;
import net.n2oapp.framework.sandbox.templates.ProjectTemplateHolder;
import net.n2oapp.framework.sandbox.templates.SearchProjectModel;
import net.n2oapp.framework.sandbox.templates.TemplateModel;
import net.n2oapp.framework.sandbox.utils.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProjectTemplateController {
    @Autowired
    private ProjectTemplateHolder templatesHolder;
    @Autowired
    private ProjectSearcher projectSearcher;

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/project"})
    public List<CategoryModel> getProjectTemplates() {
        return this.templatesHolder.getProjectTemplates();
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/project/{projectId}"})
    public ProjectModel getProject(@PathVariable(value="projectId") String projectId) {
        TemplateModel templateModel = this.templatesHolder.getTemplateModel(projectId);
        if (templateModel == null) {
            return null;
        }
        ProjectModel project = new ProjectModel();
        project.setId(projectId);
        project.setFiles(FileUtil.findResources(templateModel.getTemplateId()));
        project.setName(templateModel.getName());
        return project;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/project/search"})
    public List<SearchProjectModel> searchProjectMatches(@RequestParam(name="q") String text) throws Exception {
        return this.projectSearcher.search(text);
    }
}

