/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.resource;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Component;

@Component
public class XsdSchemaParser {
    @Value(value="${n2o.sandbox.schemas.path}")
    private String xsdFolder;
    private final ResourceLoader resourceLoader;
    private final Map<String, Resource> resourceBySchemaName = new HashMap<String, Resource>();
    private static final String XSD_HEADER_START_TAG = "<?xml";
    private static final String XSD_END_TAG = "</xs:schema>";
    private static final String XSD_NAMESPACE = "xmlns";
    private static final String CLOSE_TAG = ">";
    private static final String TYPE_ATTRIBUTE = "type=";
    private static final String BASE_ATTRIBUTE = "base=";
    private static final String REF_ATTRIBUTE = "ref=";
    private static final String NAME_ATTRIBUTE = "name=";
    private static final String GLOBAL_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String XSD_EXTENSION = ".xsd";
    private static final String DEF_PREFIX_SEPARATOR = "__";
    private static final Map<String, String> startEndDefinitionTags = Map.of("<xs:complexType", "</xs:complexType>", "<xs:simpleType", "</xs:simpleType>");

    public XsdSchemaParser(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Resource getSchema(String schemaNamespace) throws IOException {
        return this.prepareSchema(schemaNamespace, new HashSet<String>());
    }

    private Resource prepareSchema(String schemaNamespace, Set<String> preparedResourceNamespaces) throws IOException {
        String schemaName = this.getSchemaNameByNamespace(schemaNamespace);
        if (this.resourceBySchemaName.containsKey(schemaName)) {
            return this.resourceBySchemaName.get(schemaName);
        }
        Resource resource = Arrays.stream(ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath*:/**" + this.xsdFolder + "**/" + schemaName + XSD_EXTENSION)).findFirst().orElseThrow(() -> new FileNotFoundException("Schema " + schemaName + ".xsd is not found"));
        try (Stream<String> lines = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8)).lines();){
            List<String> linesList = lines.toList();
            Map<String, String> schemaNamespacesByAlias = this.getSchemaNamespaceByAliasMap(linesList);
            if (schemaNamespacesByAlias.isEmpty()) {
                this.resourceBySchemaName.put(schemaName, resource);
            } else {
                HashMap<String, List<String>> definitionRowsByName = new HashMap<String, List<String>>();
                for (String namespace : schemaNamespacesByAlias.values()) {
                    if (preparedResourceNamespaces.contains(namespace)) continue;
                    preparedResourceNamespaces.add(namespace);
                    Resource subSchema = this.prepareSchema(namespace, preparedResourceNamespaces);
                    this.fillSchemaDefinitions(subSchema, definitionRowsByName);
                }
                Resource mergedSchema = this.mergeSchemas(linesList, definitionRowsByName, schemaName, schemaNamespacesByAlias);
                this.resourceBySchemaName.put(schemaName, mergedSchema);
            }
        }
        return this.resourceBySchemaName.get(schemaName);
    }

    private void fillSchemaDefinitions(Resource schema, Map<String, List<String>> schemaDefinitions) throws IOException {
        String prefix = this.getSchemaPrefix(schema.getFilename());
        try (Stream<String> lines = new BufferedReader(new InputStreamReader(schema.getInputStream(), StandardCharsets.UTF_8)).lines();){
            List<String> linesList = lines.toList();
            int i = 0;
            while (i < linesList.size()) {
                String trimmedStr = linesList.get(i).trim();
                Optional<String> startDefTag = startEndDefinitionTags.keySet().stream().filter(trimmedStr::startsWith).findFirst();
                if (startDefTag.isPresent()) {
                    ArrayList<String> defRows = new ArrayList<String>();
                    String nameValue = this.getAttributeValue(trimmedStr, NAME_ATTRIBUTE, new String[0]);
                    if (nameValue == null) {
                        ++i;
                        continue;
                    }
                    if (this.isContainsPrefixSeparator(nameValue)) {
                        defRows.add(linesList.get(i));
                        schemaDefinitions.put(nameValue, defRows);
                    } else {
                        defRows.add(this.addPrefixToAttributeValue(linesList.get(i), nameValue, prefix));
                        schemaDefinitions.put(prefix + nameValue, defRows);
                    }
                    int defCount = 1;
                    do {
                        trimmedStr = linesList.get(++i).trim();
                        if (startEndDefinitionTags.keySet().stream().anyMatch(trimmedStr::startsWith)) {
                            ++defCount;
                        } else if (startEndDefinitionTags.values().stream().anyMatch(trimmedStr::startsWith)) {
                            --defCount;
                        }
                        String typeValue = this.getAttributeValue(trimmedStr, BASE_ATTRIBUTE, TYPE_ATTRIBUTE, REF_ATTRIBUTE);
                        String line = linesList.get(i);
                        if (typeValue != null && !this.isExternalSchemeType(typeValue)) {
                            line = this.addPrefixToAttributeValue(line, typeValue, prefix);
                        }
                        defRows.add(line);
                    } while (defCount != 0);
                }
                ++i;
            }
        }
    }

    private String getAttributeValue(String line, String attribute, String ... attributes) {
        int attrIdx = line.indexOf(attribute);
        String attr = attribute;
        if (attrIdx == -1 && attributes != null) {
            for (String s : attributes) {
                attrIdx = line.indexOf(s);
                if (attrIdx == -1) continue;
                attr = s;
                break;
            }
        }
        if (attrIdx == -1) {
            return null;
        }
        int beginNameIdx = attrIdx + attr.length() + 1;
        int lastQuoteIndex = line.indexOf("\"", beginNameIdx);
        return line.substring(beginNameIdx, lastQuoteIndex);
    }

    private Map<String, String> getSchemaNamespaceByAliasMap(List<String> linesList) {
        HashMap<String, String> schemaNamespaceByAlias = new HashMap<String, String>();
        for (String line : linesList) {
            String trimmedStr = line.trim();
            if (trimmedStr.startsWith(XSD_HEADER_START_TAG)) continue;
            int idx = trimmedStr.indexOf(XSD_NAMESPACE);
            if (idx != -1) {
                String[] split = trimmedStr.split("=");
                String alias = split[0].trim().substring(XSD_NAMESPACE.length() + 1);
                String trimmedNamespace = split[1].trim();
                int suffixLength = trimmedNamespace.endsWith(CLOSE_TAG) ? 2 : 1;
                String extSchemaNamespace = trimmedNamespace.substring(1, trimmedNamespace.length() - suffixLength);
                if (!extSchemaNamespace.equals(GLOBAL_SCHEMA)) {
                    schemaNamespaceByAlias.put(alias, extSchemaNamespace);
                }
            }
            if (!trimmedStr.endsWith(CLOSE_TAG)) continue;
            break;
        }
        return schemaNamespaceByAlias;
    }

    private Resource mergeSchemas(List<String> lines, Map<String, List<String>> extSchemaDefinitions, final String schemaName, Map<String, String> schemaNamespacesByAlias) throws IOException {
        int endSchemaIdx = lines.size() - 1;
        while (!lines.get(endSchemaIdx).trim().startsWith(XSD_END_TAG)) {
            --endSchemaIdx;
        }
        ArrayList<String> mergedSchemaLines = new ArrayList<String>();
        for (int i = 0; i < endSchemaIdx; ++i) {
            String[] split;
            String line = lines.get(i);
            String typeValue = this.getAttributeValue(lines.get(i), BASE_ATTRIBUTE, TYPE_ATTRIBUTE, REF_ATTRIBUTE);
            if (typeValue != null && (split = typeValue.split(":")).length == 2 && schemaNamespacesByAlias.containsKey(split[0])) {
                line = line.replace(split[0] + ":", this.getSchemaPrefix(this.getSchemaNameByNamespace(schemaNamespacesByAlias.get(split[0]))));
            }
            mergedSchemaLines.add(line);
        }
        for (List<String> def : extSchemaDefinitions.values()) {
            mergedSchemaLines.addAll(def);
        }
        mergedSchemaLines.add(lines.get(endSchemaIdx));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outputStream);
        for (String line : mergedSchemaLines) {
            out.write((line + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
        }
        out.flush();
        byte[] bytes = outputStream.toByteArray();
        return new ByteArrayResource(bytes){

            public String getFilename() {
                return schemaName + XsdSchemaParser.XSD_EXTENSION;
            }
        };
    }

    private String addPrefixToAttributeValue(String line, String attributeValue, String prefix) {
        int attrIdx = line.indexOf("\"" + attributeValue + "\"");
        return line.substring(0, attrIdx + 1) + prefix + line.substring(attrIdx + 1);
    }

    private String getSchemaPrefix(String schemaName) {
        return schemaName.substring(0, schemaName.lastIndexOf("-")) + DEF_PREFIX_SEPARATOR;
    }

    private String getSchemaNameByNamespace(String schemaNamespace) {
        return schemaNamespace.substring(schemaNamespace.lastIndexOf("/") + 1);
    }

    private boolean isContainsPrefixSeparator(String text) {
        return text.matches(".+__.+");
    }

    private boolean isExternalSchemeType(String type) {
        return type.matches(".+(:|__).+");
    }
}

