/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.config.io.MetadataParamHolder;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.selective.SelectiveUtil;
import net.n2oapp.framework.sandbox.scanner.ProjectFileInfo;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ProjectFileLoader
implements SourceLoader<ProjectFileInfo> {
    private NamespaceReaderFactory elementReaderFactory;

    public ProjectFileLoader(NamespaceReaderFactory elementReaderFactory) {
        this.elementReaderFactory = elementReaderFactory;
    }

    public <S extends SourceMetadata> S load(ProjectFileInfo info, String params) {
        Class sourceClass = info.getBaseSourceClass();
        try {
            Object t;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(info.getSource().getBytes());
            try {
                MetadataParamHolder.setParams((Map)RouteUtil.parseQueryParams((String)params));
                Object source = this.read(info.getId(), inputStream);
                if (!sourceClass.isAssignableFrom(source.getClass())) {
                    throw new MetadataReaderException("read class [" + String.valueOf(source.getClass()) + "], but expected [" + String.valueOf(sourceClass) + "]");
                }
                t = source;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw N2oException.wrap((Throwable)e);
                }
            }
            ((InputStream)inputStream).close();
            return (S)t;
        }
        finally {
            MetadataParamHolder.setParams(null);
        }
    }

    public <T extends SourceMetadata> T read(String id, InputStream xml) {
        Document doc;
        try {
            doc = SelectiveUtil.getSAXBuilder().build(xml);
        }
        catch (IOException | JDOMException e) {
            throw new N2oException("Error reading metadata " + id, e);
        }
        Element root = doc.getRootElement();
        SourceMetadata n2o = (SourceMetadata)this.elementReaderFactory.produce(root).read(root);
        if (n2o == null) {
            throw new MetadataReaderException("Xml Element Reader must return not null object");
        }
        n2o.setId(id);
        return (T)n2o;
    }
}

