/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.file_storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.sandbox.file_storage.FileStorage;
import net.n2oapp.framework.sandbox.file_storage.model.FileModel;
import org.apache.commons.io.IOUtils;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3FileStorage
implements FileStorage {
    private final String bucketName;
    private final S3Client s3Client;

    public S3FileStorage(S3Client s3Client, String bucketName) {
        this.bucketName = bucketName;
        this.s3Client = s3Client;
        this.createBucketIfNotExists();
    }

    private static String getObjectId(String projectId, String file) {
        return projectId + "/" + file;
    }

    @Override
    public void saveFile(String projectId, String file, String source) {
        String objectKey = S3FileStorage.getObjectId(projectId, file);
        this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(objectKey).build(), RequestBody.fromString((String)source));
    }

    @Override
    public String getFileContent(String projectId, String file) {
        String string;
        block9: {
            if (!this.isFileExists(projectId, file)) {
                return null;
            }
            InputStream inputStream = (InputStream)this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(S3FileStorage.getObjectId(projectId, file)).build(), ResponseTransformer.toInputStream());
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Override
    public List<FileModel> getProjectFiles(String projectId) {
        ArrayList<FileModel> files = new ArrayList<FileModel>();
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(projectId + "/").build();
        for (S3Object s3Object : this.s3Client.listObjectsV2(listRequest).contents()) {
            if (s3Object.key().endsWith("/")) continue;
            FileModel fileModel = new FileModel();
            String fileName = s3Object.key().substring(s3Object.key().lastIndexOf("/") + 1);
            fileModel.setFile(fileName);
            fileModel.setSource(this.getFileContent(projectId, fileName));
            files.add(fileModel);
        }
        return files;
    }

    @Override
    public boolean isProjectExists(String projectId) {
        return this.isFileExists(projectId, "index.page.xml");
    }

    private boolean isFileExists(String projectId, String file) {
        try {
            this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(S3FileStorage.getObjectId(projectId, file)).build());
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw new IllegalStateException(e);
        }
    }

    private void createBucketIfNotExists() {
        try {
            this.s3Client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucketName).build());
        }
        catch (NoSuchBucketException e) {
            this.s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucketName).build());
        }
    }
}

