/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.examples;

import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.framework.sandbox.cases.persons.Person;
import net.n2oapp.framework.sandbox.cases.persons.PersonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MyService {
    @Autowired
    private PersonRepository repository;

    public Page<Person> getList(Criteria criteria) {
        return this.repository.findAll((Pageable)PageRequest.of((int)criteria.getPage(), (int)criteria.getSize()));
    }

    public Person getOne(Integer id) {
        return (Person)this.repository.findById(id).get();
    }

    public Integer getCount(Criteria criteria) {
        return (int)this.repository.findAll((Pageable)PageRequest.of((int)criteria.getPage(), (int)criteria.getSize())).getTotalElements();
    }

    public Person create(Person p) {
        return (Person)this.repository.save(p);
    }

    public Person update(Person in) {
        Person p = (Person)this.repository.findById(in.getId()).get();
        p.setFirstName(in.getFirstName());
        p.setLastName(in.getLastName());
        this.repository.save(p);
        return p;
    }

    public void delete(Long id) {
        this.repository.deleteById(id);
    }
}

