/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases.websocket;

import jakarta.servlet.http.HttpSession;
import java.util.Random;
import net.n2oapp.framework.sandbox.cases.websocket.BadgeColor;
import net.n2oapp.framework.sandbox.cases.websocket.BadgeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/websocket"})
public class WebSocketMessageController {
    private final Random random = new Random();
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    @GetMapping(value={"/{destination}/count"})
    public String sendCount(@PathVariable String destination, HttpSession session) {
        BadgeMessage message = new BadgeMessage();
        Integer count = this.random.nextInt(14) + 1;
        message.setCount(count);
        this.messagingTemplate.convertAndSendToUser(session.getId(), destination, (Object)message);
        return "\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442\u0447\u0438\u043a \u0431\u0430\u0434\u0436\u0430: " + count.toString();
    }

    @GetMapping(value={"/{destination}/color"})
    public String sendColor(@PathVariable String destination, HttpSession session) {
        BadgeMessage message = new BadgeMessage();
        int pick = this.random.nextInt(BadgeColor.values().length);
        String color = BadgeColor.values()[pick].toString();
        message.setColor(color);
        this.messagingTemplate.convertAndSendToUser(session.getId(), destination, (Object)message);
        return "\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0446\u0432\u0435\u0442 \u0431\u0430\u0434\u0436\u0430: \"" + color + "\"";
    }
}

