/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases.nesting_object_fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.n2oapp.framework.sandbox.cases.nesting_object_fields.Department;
import net.n2oapp.framework.sandbox.cases.nesting_object_fields.Employee;
import net.n2oapp.framework.sandbox.cases.nesting_object_fields.Organization;
import org.springframework.stereotype.Component;

@Component
public class EmployeeService {
    private SortedMap<Integer, Employee> employees = new TreeMap<Integer, Employee>();

    public EmployeeService() {
        Organization organization = new Organization("2", "org2");
        List<Department> departments = Arrays.asList(new Department("3", "department3"));
        this.employees.put(1, new Employee(1, "JOE", organization, departments));
        organization = new Organization("1", "org1");
        departments = Arrays.asList(new Department("1", "department1"), new Department("2", "department2"));
        this.employees.put(2, new Employee(2, "ANN", organization, departments));
    }

    public Object findAll() {
        return new ArrayList<Employee>(this.employees.values());
    }

    public Employee findOne(Integer id) {
        return (Employee)this.employees.get(id);
    }

    public Employee create(Employee employee) {
        employee.setId(this.employees.lastKey() + 1);
        this.employees.put(employee.getId(), employee);
        return employee;
    }

    public void update(Employee employee) {
        if (this.employees.containsKey(employee.getId())) {
            this.employees.put(employee.getId(), employee);
        }
    }

    public void delete(Integer id) {
        this.employees.remove(id);
    }
}

