/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases.fileupload;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import net.n2oapp.framework.sandbox.cases.fileupload.FileModel;
import net.n2oapp.framework.sandbox.cases.fileupload.PersonModel;
import net.n2oapp.framework.sandbox.cases.fileupload.PersonStorageController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/persons"})
public class PersonDocRestController {
    private final PersonStorageController personStorageController;

    public PersonDocRestController(@Autowired PersonStorageController personStorageController) {
        this.personStorageController = personStorageController;
    }

    @GetMapping(value={"/list"})
    public PersonStorageController.ListResponse getList() {
        return this.personStorageController.getList();
    }

    @GetMapping(value={"/{id}"})
    public PersonModel getById(@PathVariable String id) {
        return this.personStorageController.getById(id);
    }

    @PostMapping(value={"/create"})
    public String createPerson(@RequestBody PersonModel person) {
        return this.personStorageController.createPerson(person);
    }

    @PutMapping(value={"/update"})
    public void updatePerson(@RequestBody PersonModel person) {
        this.personStorageController.updatePerson(person);
    }

    @DeleteMapping(value={"/{id}"})
    public void deletePerson(@PathVariable String id) {
        this.personStorageController.deletePerson(id);
    }

    @CrossOrigin(origins={"*"})
    @PostMapping(value={"/{personId}/files"})
    public ResponseEntity<FileModel> uploadFile(@PathVariable(value="personId") String personId, @RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        FileModel model = this.personStorageController.storeFile(file, request.getRequestURL().toString());
        this.personStorageController.setDoc(personId, model);
        return new ResponseEntity((Object)new FileModel(model.getId(), model.getFileName(), model.getUrl(), model.getSize(), model.getDate()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @CrossOrigin(origins={"*"})
    @DeleteMapping(value={"/{personId}/files/{id}"})
    public void deleteFile(@PathVariable String personId, @PathVariable String id) {
        this.personStorageController.deleteDoc(personId, id);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/{personId}/files/{fileName:.+}"})
    public ResponseEntity<Resource> downloadFile(@PathVariable String personId, @PathVariable String fileName, HttpServletRequest request) {
        Resource resource = this.personStorageController.loadFile(fileName);
        String contentType = null;
        try {
            contentType = request.getServletContext().getMimeType(resource.getFile().getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).body((Object)resource);
    }
}

