/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.sandbox.cases.fileupload;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import net.n2oapp.framework.sandbox.cases.fileupload.FileModel;
import net.n2oapp.framework.sandbox.cases.fileupload.FileStorageController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class FilesRestController {
    private final FileStorageController fileStorageController;

    @Autowired
    public FilesRestController(@Autowired FileStorageController fileStorageController) {
        this.fileStorageController = fileStorageController;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/files/list"})
    public FileStorageController.ListResponse getList() {
        return this.fileStorageController.getList();
    }

    @CrossOrigin(origins={"*"})
    @PostMapping(path={"/files"})
    public ResponseEntity<FileModel> uploadFile(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        FileModel model = this.fileStorageController.storeFile(file, request.getRequestURL().toString());
        return new ResponseEntity((Object)new FileModel(model.getId(), model.getFileName(), model.getUrl(), model.getSize(), model.getDate()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @CrossOrigin(origins={"*"})
    @DeleteMapping(path={"/files/{id}"})
    public void deleteFile(@PathVariable String id) {
        this.fileStorageController.delete(id);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/files/{fileName:.+}"})
    public ResponseEntity<Resource> downloadFile(@PathVariable String fileName, HttpServletRequest request, @RequestHeader(value="hasAttachment", required=false) Boolean hasAttachment) {
        return this.getResourceResponseEntity(null, fileName, request, hasAttachment);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/stores/{storeKey}/files/list"})
    public FileStorageController.ListResponse getStoreFiles(@PathVariable(required=false) String storeKey) {
        return this.fileStorageController.getList(storeKey);
    }

    @CrossOrigin(origins={"*"})
    @PostMapping(path={"/stores/{storeKey}/files"})
    public ResponseEntity<FileModel> uploadStoreFile(@PathVariable String storeKey, @RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        FileModel model = this.fileStorageController.storeFile(file, request.getRequestURL().toString(), storeKey);
        return new ResponseEntity((Object)new FileModel(model.getId(), model.getFileName(), model.getUrl(), model.getSize(), model.getDate()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @CrossOrigin(origins={"*"})
    @DeleteMapping(path={"/stores/{storeKey}/files/{id}"})
    public void deleteStoreFile(@PathVariable String storeKey, @PathVariable String id) {
        this.fileStorageController.delete(id, storeKey);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/stores/{storeKey}/files/{fileName:.+}"})
    public ResponseEntity<Resource> downloadStoreFile(@PathVariable String storeKey, @PathVariable String fileName, HttpServletRequest request, @RequestHeader(value="hasAttachment", required=false) Boolean hasAttachment) {
        return this.getResourceResponseEntity(storeKey, fileName, request, hasAttachment);
    }

    private ResponseEntity<Resource> getResourceResponseEntity(String storeKey, String fileName, HttpServletRequest request, Boolean hasAttachment) {
        Resource resource = this.fileStorageController.loadFile(fileName, storeKey);
        String contentType = null;
        try {
            contentType = request.getServletContext().getMimeType(resource.getFile().getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        String headerValues = "filename=\"" + resource.getFilename() + "\"";
        if (Boolean.FALSE != hasAttachment) {
            headerValues = "attachment; " + headerValues;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{headerValues})).body((Object)resource);
    }
}

