import React, { memo, useMemo } from 'react'

import { Selection } from '../enum'
import { TableHeaderProps } from '../types/props'
import { parseHeaderRows } from '../utils/parseHeaderRows'

import { CheckboxHeaderCell } from './selection/checkbox-header'
import { TableHeaderCell } from './header-cell'
import Table from './basic'

export const TableHeader = memo<TableHeaderProps>(({
    selection,
    areAllRowsSelected,
    cells,
    sorting,
    validateFilterField,
    filterErrors,
}) => {
    const rows = useMemo(() => parseHeaderRows(cells), [cells])

    return (
        <Table.Header>
            {rows.map(columns => (
                <Table.Row>
                    {selection === Selection.Checkbox ? (
                        <Table.HeaderCell key={selection} className="cell-selection">
                            <CheckboxHeaderCell areAllRowsSelected={areAllRowsSelected} />
                        </Table.HeaderCell>
                    ) : null}
                    {selection === Selection.Radio ? (
                        <Table.HeaderCell key={selection} className="cell-selection" />
                    ) : null}
                    {columns.map(cell => (
                        <TableHeaderCell
                            key={cell.id}
                            sortingDirection={cell.sortingParam ? sorting[cell.sortingParam] : undefined}
                            validateFilterField={validateFilterField}
                            filterError={filterErrors?.[cell.id]}
                            {...cell}
                        />
                    ))}
                </Table.Row>
            ))}
        </Table.Header>
    )
})
