import PropTypes from 'prop-types'

export const defaultProps = {
    disabled: false,
    loading: false,
    parentFieldId: 'parentId',
    valueFieldId: 'id',
    labelFieldId: 'label',
    iconFieldId: 'icon',
    badge: {
        fieldId: 'badge',
        colorFieldId: 'color',
    },
    hasCheckboxes: false,
    datasource: [],
    parentIcon: '',
    childIcon: '',
    draggable: true,
    multiselect: true,
    prefixCls: 'n2o-rc-tree',
    icon: '',
    selectable: true,
    showLine: false,
    filter: '',
    expandBtn: false,
    onResolve: () => {},
    onDrop: () => {},
    filterPlaceholder: 'Поиск...',
}

export const propTypes = {
    disabled: PropTypes.bool,
    loading: PropTypes.bool,
    parentFieldId: PropTypes.string,
    valueFieldId: PropTypes.string,
    labelFieldId: PropTypes.string,
    iconFieldId: PropTypes.string,
    imageFieldId: PropTypes.string,
    badge: PropTypes.object,
    hasCheckboxes: PropTypes.bool,
    datasource: PropTypes.array,
    parentIcon: PropTypes.string,
    childIcon: PropTypes.string,
    prefixCls: PropTypes.string,
    multiselect: PropTypes.bool,
    icon: PropTypes.string,
    selectable: PropTypes.bool,
    showLine: PropTypes.bool,
    filter: PropTypes.string,
    expandBtn: PropTypes.bool,
    onResolve: PropTypes.func,
    onDrop: PropTypes.func,
    filterPlaceholder: PropTypes.string,
}

export const TREE_PROPS = [
    'loading',
    'disabled',
    'selectable',
    'showLine',
    'prefixCls',
]

export const TREE_NODE_PROPS = [
    'labelFieldId',
    'iconFieldId',
    'imageFieldId',
    'badge',
    'childIcon',
    'parentIcon',
    'valueFieldId',
    'parentFieldId',
    'prefixCls',
    'filter',
]
