/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;

public class ServletUtil {
    public static Map<String, String> decodeParameters(HttpServletRequest request) {
        try {
            String[] parameters;
            if (request.getQueryString() == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String parameter : parameters = request.getQueryString().split("&")) {
                String[] keyValue = parameter.split("=");
                String key = URLDecoder.decode(keyValue[0], "UTF-8");
                if (keyValue.length == 2) {
                    String value = URLDecoder.decode(keyValue[1], "UTF-8");
                    map.put(key, value);
                    continue;
                }
                if (keyValue.length != 1) continue;
                map.put(key, null);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> filterParameters(Map<String, String> parameters, Predicate<String> filter) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(parameters);
        parameters.keySet().stream().filter(filter.negate()).forEach(result::remove);
        return result;
    }
}

