/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.n2o;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.meta.saga.AlertSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.AlertMessagesConstructor;
import net.n2oapp.framework.api.user.StaticUserContext;
import net.n2oapp.framework.api.user.UserContext;
import net.n2oapp.framework.config.register.route.RouteNotFoundException;
import net.n2oapp.framework.mvc.cache.ClientCacheTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.PropertyResolver;

public abstract class N2oServlet
extends HttpServlet {
    protected static final Log logger = LogFactory.getLog(N2oServlet.class);
    public static final String USER = "user";
    protected ObjectMapper objectMapper = new ObjectMapper();
    private AlertMessageBuilder messageBuilder;
    private ClientCacheTemplate clientCacheTemplate;
    private PropertyResolver propertyResolver;
    private AlertMessagesConstructor messagesConstructor;

    public void init() throws ServletException {
        super.init();
        if (this.messageBuilder == null) {
            this.messageBuilder = new AlertMessageBuilder(new MessageSourceAccessor((MessageSource)new ResourceBundleMessageSource()), this.propertyResolver);
        }
    }

    public UserContext getUser(HttpServletRequest req) {
        UserContext user = (UserContext)req.getAttribute(USER);
        if (user == null) {
            throw new IllegalStateException("User is not initialized");
        }
        return user;
    }

    private void setUser(HttpServletRequest req) {
        UserContext user = (UserContext)req.getAttribute(USER);
        if (user == null) {
            req.setAttribute(USER, (Object)StaticUserContext.getUserContext());
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.setUser(req);
            if (this.clientCacheTemplate != null) {
                this.clientCacheTemplate.execute(req, resp, this::safeDoGet);
            } else {
                this.safeDoGet(req, resp);
            }
        }
        catch (Exception e) {
            this.sendError(req, resp, e);
        }
    }

    protected void safeDoGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setUser(req);
        try {
            this.safeDoPost(req, resp);
        }
        catch (Exception e) {
            this.sendError(req, resp, e);
        }
    }

    protected void safeDoPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setUser(req);
        try {
            this.safeDoPut(req, resp);
        }
        catch (Exception e) {
            this.sendError(req, resp, e);
        }
    }

    protected void safeDoPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setUser(req);
        try {
            this.safeDoDelete(req, resp);
        }
        catch (Exception e) {
            this.sendError(req, resp, e);
        }
    }

    protected void safeDoDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
    }

    protected Object getRequestBody(HttpServletRequest request) {
        try {
            if (request.getReader() == null) {
                return new DataSet();
            }
            String body = IOUtils.toString((Reader)request.getReader()).trim();
            if (body.startsWith("[")) {
                return this.objectMapper.readValue(body, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, DataSet.class));
            }
            return this.objectMapper.readValue(body, DataSet.class);
        }
        catch (IOException e) {
            throw new N2oException((Throwable)e);
        }
    }

    protected Map<String, String[]> getHeaders(HttpServletRequest req) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Enumeration iter = req.getHeaderNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            result.put(name, new String[]{req.getHeader(name)});
        }
        return result;
    }

    private void sendError(HttpServletRequest req, HttpServletResponse resp, Exception e) throws IOException {
        int status = e instanceof N2oException ? ((N2oException)e).getHttpStatus() : 500;
        logger.error((Object)("Error response " + status + " " + req.getMethod() + " " + req.getRequestURI() + (String)(req.getQueryString() != null ? "?" + req.getQueryString() : "")), (Throwable)e);
        if (resp.isCommitted()) {
            return;
        }
        resp.setContentType("application/json");
        resp.setStatus(status);
        if (!(e instanceof RouteNotFoundException)) {
            MetaSaga meta = this.buildMeta(e);
            this.objectMapper.writeValue((Writer)resp.getWriter(), Collections.singletonMap("meta", meta));
        }
    }

    private MetaSaga buildMeta(Exception exception) {
        MetaSaga meta = new MetaSaga();
        meta.setAlert(new AlertSaga());
        meta.getAlert().setMessages(this.messagesConstructor.constructMessages(exception));
        return meta;
    }

    public AlertMessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public void setMessageBuilder(AlertMessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
    }

    public void setMessagesConstructor(AlertMessagesConstructor messagesConstructor) {
        this.messagesConstructor = messagesConstructor;
    }

    public void setClientCacheTemplate(ClientCacheTemplate clientCacheTemplate) {
        this.clientCacheTemplate = clientCacheTemplate;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }
}

