/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.migrate;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.RefIdAware;
import net.n2oapp.framework.api.metadata.io.ClassedElementIO;
import net.n2oapp.framework.api.metadata.io.ElementIOFactory;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.NamedElementIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.persister.TypedElementPersister;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import net.n2oapp.framework.migrate.MigratorElementIOFactoryByMap;
import net.n2oapp.framework.migrate.MigratorInfoHolder;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MigratorIOProcessorImpl
extends IOProcessorImpl {
    private static final String BODY_KEY = "body";
    private static final String CDATA_KEY = "cdata";

    public MigratorIOProcessorImpl(NamespaceReaderFactory readerFactory, MetadataEnvironment environment) {
        super(readerFactory, environment);
    }

    public MigratorIOProcessorImpl(NamespacePersisterFactory persisterFactory, MetadataEnvironment environment) {
        super(persisterFactory, environment);
    }

    public void attribute(Element element, String name, Supplier<String> getter, Consumer<String> setter) {
        this.attribute(element, name, getter, setter, String::valueOf);
    }

    public void attributeBoolean(Element element, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        this.attribute(element, name, getter, setter, Boolean::valueOf);
    }

    public void attributeInteger(Element element, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        this.attribute(element, name, getter, setter, Integer::valueOf);
    }

    public void text(Element element, Supplier<String> getter, Consumer<String> setter) {
        this.processText(element, null, getter, setter, false);
    }

    public void childrenText(Element element, String childName, Supplier<String> getter, Consumer<String> setter) {
        this.processText(element, childName, getter, setter, false);
    }

    public void originalText(Element element, Supplier<String> getter, Consumer<String> setter) {
        this.processText(element, null, getter, setter, true);
    }

    public void childrenOriginalText(Element element, String childName, Supplier<String> getter, Consumer<String> setter) {
        this.processText(element, childName, getter, setter, true);
    }

    public void childAttribute(Element element, String childName, String name, Supplier<String> getter, Consumer<String> setter) {
        this.childAttribute(element, childName, name, getter, setter, String::valueOf);
    }

    public void childAttributeBoolean(Element element, String childName, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        this.childAttribute(element, childName, name, getter, setter, Boolean::valueOf);
    }

    public void childAttributeInteger(Element element, String childName, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        this.childAttribute(element, childName, name, getter, setter, Integer::valueOf);
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> ElementIOFactory<T, R, P> oneOf(Class<T> baseElementClass) {
        return new MigratorElementIOFactoryByMap(baseElementClass);
    }

    protected <T> Element persist(NamedElementIO<T> io, T entity, Namespace namespace) {
        Element element = new Element(io.getElementName(), namespace);
        MigratorInfoHolder.pushCurrentSource(entity);
        io.io(element, entity, (IOProcessor)this);
        MigratorInfoHolder.popCurrentSource();
        return element;
    }

    protected <T> T read(ClassedElementIO<T> io, Element element) {
        Object entity = io.newInstance(element);
        MigratorInfoHolder.pushCurrentSource(entity);
        io.io(element, entity, (IOProcessor)this);
        MigratorInfoHolder.popCurrentSource();
        return (T)entity;
    }

    public <T extends RefIdAware> void merge(T source, String elementName) {
    }

    private <T> void attribute(Element element, String name, Supplier<T> getter, Consumer<T> setter, Function<String, T> valueFunction) {
        if (this.isR()) {
            MigratorIOProcessorImpl.readAttribute(element, name, setter, valueFunction);
        } else {
            MigratorIOProcessorImpl.writeAttribute(element, name, getter);
        }
    }

    private <T> void childAttribute(Element element, String childName, String name, Supplier<T> getter, Consumer<T> setter, Function<String, T> valueFunction) {
        Element child = element.getChild(childName, element.getNamespace());
        if (super.isR()) {
            if (child == null) {
                return;
            }
            MigratorIOProcessorImpl.readAttribute(child, name, setter, valueFunction);
        } else {
            if (getter.get() == null) {
                return;
            }
            if (child == null) {
                child = new Element(childName, element.getNamespace());
                element.addContent((Content)child);
            }
            MigratorIOProcessorImpl.writeAttribute(child, name, getter);
        }
    }

    private void processText(Element element, String childName, Supplier<String> getter, Consumer<String> setter, boolean isOriginalText) {
        if (this.isR()) {
            this.readText(element, childName, setter, isOriginalText);
        } else {
            this.writeText(element, childName, getter);
        }
    }

    private void readText(Element element, String childName, Consumer<String> setter, boolean isOriginalText) {
        Element targetElement;
        Element element2 = targetElement = childName != null ? element.getChild(childName, element.getNamespace()) : element;
        if (targetElement == null) {
            return;
        }
        String text = targetElement.getText();
        if (text != null && !text.isEmpty()) {
            if (targetElement.getContent().stream().anyMatch(c -> Content.CType.CDATA.equals((Object)c.getCType()))) {
                MigratorInfoHolder.addProperty(CDATA_KEY + this.getKeySuffix(childName), text);
                setter.accept(text);
            } else {
                MigratorInfoHolder.addProperty(BODY_KEY + this.getKeySuffix(childName), text);
                setter.accept(isOriginalText ? text : null);
            }
        }
    }

    private void writeText(Element element, String childName, Supplier<String> getter) {
        String value = getter.get();
        String keySuffix = this.getKeySuffix(childName);
        if (value != null) {
            Element targetElement = this.getOrCreateTargetElement(element, childName);
            if (MigratorInfoHolder.getProperty(CDATA_KEY + keySuffix) != null) {
                targetElement.setContent((Content)new CDATA(value));
            } else {
                targetElement.setText(value);
            }
        } else {
            String propertyKey = BODY_KEY + keySuffix;
            String storedValue = MigratorInfoHolder.getProperty(propertyKey);
            if (storedValue != null) {
                Element targetElement = this.getOrCreateTargetElement(element, childName);
                targetElement.setText(storedValue);
            }
        }
    }

    private Element getOrCreateTargetElement(Element parent, String childName) {
        if (childName == null) {
            return parent;
        }
        Element child = parent.getChild(childName, parent.getNamespace());
        if (child == null) {
            child = new Element(childName, parent.getNamespace());
            parent.addContent((Content)child);
        }
        return child;
    }

    private String getKeySuffix(String childName) {
        return childName != null ? "." + childName : "";
    }

    private static <T> void readAttribute(Element element, String name, Consumer<T> setter, Function<String, T> valueFunction) {
        Attribute attribute = element.getAttribute(name);
        if (attribute != null) {
            String value = attribute.getValue();
            if (value != null && value.startsWith("${") && value.endsWith("}")) {
                MigratorInfoHolder.addProperty(name, value);
                setter.accept(null);
            } else {
                setter.accept(valueFunction.apply(value));
            }
        }
    }

    private static <T> void writeAttribute(Element element, String name, Supplier<T> getter) {
        if (getter.get() != null) {
            element.setAttribute(new Attribute(name, getter.get().toString()));
        } else if (MigratorInfoHolder.getProperty(name) != null) {
            element.setAttribute(new Attribute(name, MigratorInfoHolder.getProperty(name)));
        }
    }

    protected String process(String text) {
        return text;
    }
}

