/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.migrate;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.reader.ElementReaderFactory;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.selective.SelectiveUtil;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import net.n2oapp.framework.config.selective.reader.ReaderFactoryByMap;
import net.n2oapp.framework.migrate.MigratorIOProcessorImpl;
import net.n2oapp.framework.migrate.MigratorInfoHolder;
import net.n2oapp.framework.migrate.MigratorProxyNamespaceIO;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.stereotype.Component;

@Component
public class XmlIOVersionMigrator {
    private final NamespaceReaderFactory readerFactory;
    private final NamespacePersisterFactory persisterFactory;
    private static final XMLOutputter XML_OUTPUTTER = new XMLOutputter(Format.getPrettyFormat().setIndent("    "));
    private static final String XML_HEADER = "<?xml version='1.0' encoding='UTF-8'?>\r\n";
    private static final Map<String, String> namespaceUriMapping = Map.of("http://n2oapp.net/framework/config/schema/query-4.0", "http://n2oapp.net/framework/config/schema/query-5.0", "http://n2oapp.net/framework/config/schema/application-2.0", "http://n2oapp.net/framework/config/schema/application-3.0");

    public XmlIOVersionMigrator(N2oApplicationBuilder builder) {
        ReaderFactoryByMap readerFactoryByMap = new ReaderFactoryByMap(builder.getEnvironment());
        readerFactoryByMap.setIOProcessor((IOProcessor)new MigratorIOProcessorImpl((NamespaceReaderFactory)readerFactoryByMap, builder.getEnvironment()));
        NamespaceReaderFactory namespaceReaderFactory = builder.getEnvironment().getNamespaceReaderFactory();
        if (namespaceReaderFactory instanceof ReaderFactoryByMap) {
            ReaderFactoryByMap factoryByMap = (ReaderFactoryByMap)namespaceReaderFactory;
            factoryByMap.getMap().values().stream().flatMap(v -> v.values().stream()).map(ProxyNamespaceIO.class::cast).forEach(proxy -> readerFactoryByMap.add(new MigratorProxyNamespaceIO(proxy.getIo())));
        }
        this.readerFactory = readerFactoryByMap;
        PersisterFactoryByMap persisterFactoryByMap = new PersisterFactoryByMap();
        persisterFactoryByMap.setIOProcessor((IOProcessor)new MigratorIOProcessorImpl((NamespacePersisterFactory)persisterFactoryByMap, builder.getEnvironment()));
        NamespacePersisterFactory namespacePersisterFactory = builder.getEnvironment().getNamespacePersisterFactory();
        if (namespacePersisterFactory instanceof PersisterFactoryByMap) {
            PersisterFactoryByMap factoryByMap = (PersisterFactoryByMap)namespacePersisterFactory;
            factoryByMap.getMap().values().stream().flatMap(v -> v.values().stream()).map(ProxyNamespaceIO.class::cast).forEach(proxy -> persisterFactoryByMap.add(new MigratorProxyNamespaceIO(proxy.getIo())));
        }
        this.persisterFactory = persisterFactoryByMap;
    }

    public String migrate(String source) {
        SourceMetadata sourceObject = (SourceMetadata)SelectiveUtil.read((String)source, (ElementReaderFactory)this.readerFactory);
        String oldNamespaceUri = sourceObject.getNamespaceUri();
        String newNamespaceUri = namespaceUriMapping.get(oldNamespaceUri);
        if (newNamespaceUri == null) {
            return null;
        }
        sourceObject.setNamespaceUri(newNamespaceUri);
        Element xmlElement = this.persisterFactory.produce(sourceObject.getClass(), new Namespace[]{sourceObject.getNamespace()}).persist((Object)sourceObject, sourceObject.getNamespace());
        MigratorInfoHolder.clear();
        return XML_HEADER + XML_OUTPUTTER.outputString(xmlElement).replace(" />", "/>").replace(" xmlns=\"" + oldNamespaceUri + "\"", "");
    }

    public void migrateFile(String filePath, String directory) throws IOException {
        Path path = Paths.get(directory + filePath, new String[0]);
        String oldVersionXml = Files.readString(path);
        String migratedXml = this.migrate(oldVersionXml);
        if (migratedXml != null) {
            Files.writeString(path, (CharSequence)migratedXml, new OpenOption[0]);
        }
    }

    public boolean migrateFiles(String fileType, String namespaceUri, String directory) throws IOException {
        ArrayList oldVersionXmlFiles = new ArrayList();
        Path dir = Paths.get(directory, new String[0]);
        try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
            paths.filter(path -> path.toString().endsWith(fileType)).forEach(path -> {
                try {
                    String oldVersionXml = Files.readString(path);
                    if (oldVersionXml.contains(namespaceUri) && !oldVersionXml.contains("${")) {
                        oldVersionXmlFiles.add(path.toString().replace("\\", "/").replace(directory, ""));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        for (String file : oldVersionXmlFiles) {
            this.migrateFile(file, directory);
        }
        return true;
    }
}

