/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.migrate;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class MigratorInfoHolder {
    private static final ThreadLocal<Stack<Object>> currentSourceScope = ThreadLocal.withInitial(Stack::new);
    private static final ThreadLocal<Map<Object, Map<String, String>>> attributePropertiesScope = ThreadLocal.withInitial(HashMap::new);

    private MigratorInfoHolder() {
    }

    public static void addProperty(String name, String value) {
        Object currentSource = MigratorInfoHolder.getCurrentSource();
        if (currentSource == null) {
            return;
        }
        Map<Object, Map<String, String>> propertiesMap = attributePropertiesScope.get();
        if (propertiesMap.containsKey(currentSource)) {
            Map<String, String> innerMap = propertiesMap.get(currentSource);
            innerMap.put(name, value);
        } else {
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put(name, value);
            propertiesMap.put(currentSource, innerMap);
        }
    }

    public static String getProperty(String name) {
        Object currentSource = MigratorInfoHolder.getCurrentSource();
        if (currentSource == null) {
            return null;
        }
        Map<String, String> properties = attributePropertiesScope.get().get(currentSource);
        return properties != null ? properties.get(name) : null;
    }

    public static void pushCurrentSource(Object source) {
        currentSourceScope.get().push(source);
    }

    public static void popCurrentSource() {
        Stack<Object> stack = currentSourceScope.get();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    private static Object getCurrentSource() {
        Stack<Object> stack = currentSourceScope.get();
        return stack.isEmpty() ? null : stack.peek();
    }

    public static void clear() {
        currentSourceScope.remove();
        attributePropertiesScope.remove();
    }
}

