/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.migrate;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.RefIdAware;
import net.n2oapp.framework.api.metadata.io.ClassedElementIO;
import net.n2oapp.framework.api.metadata.io.ElementIOFactory;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.NamedElementIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.persister.TypedElementPersister;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import net.n2oapp.framework.migrate.MigratorElementIOFactoryByMap;
import net.n2oapp.framework.migrate.MigratorInfoHolder;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MigratorIOProcessorImpl
extends IOProcessorImpl {
    private static final String BODY_KEY = "body";

    public MigratorIOProcessorImpl(NamespaceReaderFactory readerFactory, MetadataEnvironment environment) {
        super(readerFactory, environment);
    }

    public MigratorIOProcessorImpl(NamespacePersisterFactory persisterFactory, MetadataEnvironment environment) {
        super(persisterFactory, environment);
    }

    public void attribute(Element element, String name, Supplier<String> getter, Consumer<String> setter) {
        this.attribute(element, name, getter, setter, String::valueOf);
    }

    public void attributeBoolean(Element element, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        this.attribute(element, name, getter, setter, Boolean::valueOf);
    }

    public void attributeInteger(Element element, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        this.attribute(element, name, getter, setter, Integer::valueOf);
    }

    public void text(Element element, Supplier<String> getter, Consumer<String> setter) {
        if (this.isR()) {
            String text = element.getText();
            if (text != null && !text.isEmpty()) {
                MigratorInfoHolder.addProperty(BODY_KEY, text);
                setter.accept(null);
            }
        } else if (getter.get() != null) {
            element.setText(getter.get());
        } else if (MigratorInfoHolder.getProperty(BODY_KEY) != null) {
            element.setText(MigratorInfoHolder.getProperty(BODY_KEY));
        }
    }

    public void childrenText(Element element, String childName, Supplier<String> getter, Consumer<String> setter) {
        this.childrenOriginalText(element, childName, getter, setter);
    }

    public void childAttribute(Element element, String childName, String name, Supplier<String> getter, Consumer<String> setter) {
        this.childAttribute(element, childName, name, getter, setter, String::valueOf);
    }

    public void childAttributeBoolean(Element element, String childName, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        this.childAttribute(element, childName, name, getter, setter, Boolean::valueOf);
    }

    public void childAttributeInteger(Element element, String childName, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        this.childAttribute(element, childName, name, getter, setter, Integer::valueOf);
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> ElementIOFactory<T, R, P> oneOf(Class<T> baseElementClass) {
        return new MigratorElementIOFactoryByMap(baseElementClass);
    }

    protected <T> Element persist(NamedElementIO<T> io, T entity, Namespace namespace) {
        Element element = new Element(io.getElementName(), namespace);
        MigratorInfoHolder.pushCurrentSource(entity);
        io.io(element, entity, (IOProcessor)this);
        MigratorInfoHolder.popCurrentSource();
        return element;
    }

    protected <T> T read(ClassedElementIO<T> io, Element element) {
        Object entity = io.newInstance(element);
        MigratorInfoHolder.pushCurrentSource(entity);
        io.io(element, entity, (IOProcessor)this);
        MigratorInfoHolder.popCurrentSource();
        return (T)entity;
    }

    public <T extends RefIdAware> void merge(T source, String elementName) {
    }

    private <T> void attribute(Element element, String name, Supplier<T> getter, Consumer<T> setter, Function<String, T> valueFunction) {
        if (this.isR()) {
            MigratorIOProcessorImpl.readAttribute(element, name, setter, valueFunction);
        } else {
            MigratorIOProcessorImpl.writeAttribute(element, name, getter);
        }
    }

    private <T> void childAttribute(Element element, String childName, String name, Supplier<T> getter, Consumer<T> setter, Function<String, T> valueFunction) {
        Element child = element.getChild(childName, element.getNamespace());
        if (super.isR()) {
            if (child == null) {
                return;
            }
            MigratorIOProcessorImpl.readAttribute(child, name, setter, valueFunction);
        } else {
            if (child == null) {
                child = new Element(childName, element.getNamespace());
                element.addContent((Content)child);
            }
            MigratorIOProcessorImpl.writeAttribute(child, name, getter);
        }
    }

    private static <T> void readAttribute(Element element, String name, Consumer<T> setter, Function<String, T> valueFunction) {
        Attribute attribute = element.getAttribute(name);
        if (attribute != null) {
            String value = attribute.getValue();
            if (value != null && value.startsWith("${") && value.endsWith("}")) {
                MigratorInfoHolder.addProperty(name, value);
                setter.accept(null);
            } else {
                setter.accept(valueFunction.apply(value));
            }
        }
    }

    private static <T> void writeAttribute(Element element, String name, Supplier<T> getter) {
        if (getter.get() != null) {
            element.setAttribute(new Attribute(name, getter.get().toString()));
        } else if (MigratorInfoHolder.getProperty(name) != null) {
            element.setAttribute(new Attribute(name, MigratorInfoHolder.getProperty(name)));
        }
    }
}

