/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.n2oapp.criteria.dataset.DataList;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.SeverityTypeEnum;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.engine.validation.engine.FailInfo;

public class Validator
implements Iterable<Validation> {
    private InvocationProcessor serviceProvider;
    private DomainProcessor domainProcessor;
    private DataSet dataSet;
    private List<Validation> validationList;
    private N2oValidation.ServerMomentEnum moment;
    private Boolean widgetWasValidated = false;
    private Set<String> validatedFields = new HashSet<String>();
    private Set<String> usedValidations = new HashSet<String>();
    private List<FailInfo> fails = new ArrayList<FailInfo>();
    private boolean afterDanger = false;
    private static final String MULTISET_INDEX_KEY = "index";
    private static final String MULTISET_INDEX_PREFIX = "$index_";
    private static final String MULTISET_INDEX_PREFIX_ESC = "\\$index_";

    public List<FailInfo> validate() {
        if (this.validationList == null) {
            return Collections.emptyList();
        }
        for (Validation v : this.validationList) {
            this.handleValidation(v, this.fails);
        }
        return this.fails;
    }

    private void handleValidation(Validation v, List<FailInfo> fails) {
        if (this.checkValidation(v)) {
            if (this.isMultiSet(v.getFieldId())) {
                int maxLevel = this.getMaxLevel(v.getFieldId());
                if (v.getFieldId().contains("[index]")) {
                    String commonFieldId = v.getFieldId();
                    String commonMessage = StringUtils.resolveLinks((String)v.getMessage(), (Object)this.dataSet);
                    String commonMessageTitle = StringUtils.resolveLinks((String)v.getMessageTitle(), (Object)this.dataSet);
                    String multiSetId = this.getMultiSetId(v.getFieldId());
                    int count = this.dataSet.containsKey((Object)multiSetId) ? ((DataList)this.dataSet.get((Object)multiSetId)).size() : 0;
                    for (int i = 0; i < count; ++i) {
                        try {
                            Validation copiedValidation = (Validation)v.getClass().getConstructor(v.getClass()).newInstance(v);
                            copiedValidation.setFieldId(this.replaceIndex(commonFieldId, MULTISET_INDEX_KEY, i));
                            copiedValidation.setMessage(this.replaceIndex(commonMessage, MULTISET_INDEX_KEY, i));
                            copiedValidation.setMessageTitle(this.replaceIndex(commonMessageTitle, MULTISET_INDEX_KEY, i));
                            this.dataSet.put(MULTISET_INDEX_KEY, (Object)i);
                            if (maxLevel != 0) {
                                this.validateByIndex(copiedValidation, 1, maxLevel, (DataSet)((DataList)this.dataSet.get((Object)multiSetId)).get(i));
                                continue;
                            }
                            this.validateField(copiedValidation, fails);
                            continue;
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            throw new N2oException("Failed copy validation", (Throwable)e);
                        }
                    }
                    this.dataSet.remove((Object)MULTISET_INDEX_KEY);
                } else {
                    this.validateByIndex(v, 1, maxLevel, this.dataSet);
                }
            } else {
                this.validateField(v, fails);
            }
        }
    }

    private int getMaxLevel(String fieldId) {
        if (fieldId.contains(MULTISET_INDEX_PREFIX)) {
            String[] splitByPrefix = fieldId.split(MULTISET_INDEX_PREFIX_ESC);
            return Integer.parseInt(splitByPrefix[splitByPrefix.length - 1].substring(0, splitByPrefix[splitByPrefix.length - 1].lastIndexOf("]")));
        }
        return 0;
    }

    private void validateByIndex(Validation validation, int level, int maxLevel, DataSet currentDs) {
        String placeholder = MULTISET_INDEX_PREFIX + level;
        if (validation.getFieldId().contains(placeholder)) {
            String placeholderEsc = MULTISET_INDEX_PREFIX_ESC + level;
            String multiSetId = this.getInnerMultiSetId(validation.getFieldId(), level);
            int count = currentDs.containsKey((Object)multiSetId) ? ((DataList)currentDs.get((Object)multiSetId)).size() : 0;
            for (int i = 0; i < count; ++i) {
                try {
                    Validation copiedValidation = (Validation)validation.getClass().getConstructor(validation.getClass()).newInstance(validation);
                    copiedValidation.setFieldId(this.replaceIndex(validation.getFieldId(), placeholderEsc, i));
                    copiedValidation.setMessage(this.replaceIndex(validation.getMessage(), placeholderEsc, i));
                    copiedValidation.setMessageTitle(this.replaceIndex(validation.getMessageTitle(), placeholderEsc, i));
                    this.dataSet.put(placeholder, (Object)i);
                    if (level == maxLevel) {
                        this.validateField(copiedValidation, this.fails);
                        this.dataSet.remove((Object)placeholder);
                        return;
                    }
                    this.validateByIndex(copiedValidation, level + 1, maxLevel, (DataSet)((DataList)currentDs.get((Object)multiSetId)).get(i));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new N2oException("Failed copy validation", (Throwable)e);
                }
            }
        }
        if (level != maxLevel) {
            this.validateByIndex(validation, level + 1, maxLevel, currentDs);
        }
    }

    private String replaceIndex(String text, String placeholder, int i) {
        return text == null ? null : text.replaceAll("\\[" + placeholder + "]", "[" + i + "]");
    }

    private void validateField(Validation v, List<FailInfo> fails) {
        v.validate(this.dataSet, this.serviceProvider, message -> {
            FailInfo failInfo = new FailInfo();
            failInfo.setMoment(v.getMoment());
            failInfo.setValidationId(v.getId());
            failInfo.setValidationClass(v.getClass().getSimpleName());
            failInfo.setSeverity(v.getSeverity());
            failInfo.setFieldId(v.isForField() ? v.getFieldId() : null);
            failInfo.setMessage(StringUtils.resolveLinks((String)v.getMessage(), (Object)this.dataSet));
            failInfo.setMessageTitle(StringUtils.resolveLinks((String)v.getMessageTitle(), (Object)this.dataSet));
            fails.add(failInfo);
            this.afterFail(v);
        }, this.domainProcessor);
    }

    private String getMultiSetId(String fieldId) {
        return fieldId.split("\\[index\\].")[0];
    }

    private String getInnerMultiSetId(String fieldId, int index) {
        String first = fieldId.split("\\[\\$index_" + index + "\\].")[0];
        return first.substring(first.lastIndexOf(46) + 1);
    }

    private boolean isMultiSet(String fieldId) {
        return fieldId != null && (fieldId.contains("[index]") || fieldId.contains("[$index_"));
    }

    private void afterFail(Validation v) {
        if (SeverityTypeEnum.DANGER.equals((Object)v.getSeverity())) {
            this.afterDanger = true;
        }
        if (!v.isForField()) {
            this.widgetWasValidated = true;
        } else {
            this.validatedFields.add(v.getFieldId());
        }
        this.usedValidations.add(v.getId());
    }

    private boolean checkValidation(Validation validation) {
        return this.checkAfterDanger(validation) && this.checkEnabled(validation) && this.checkMoment(validation) && this.checkUnique(validation) && this.checkUsed(validation) && this.checkRequiredConstraint(validation) && this.checkSide(validation);
    }

    private boolean checkSide(Validation validation) {
        return validation.getSide() == null || validation.getSide().contains("server");
    }

    private boolean checkAfterDanger(Validation validation) {
        if (SeverityTypeEnum.DANGER.equals((Object)validation.getSeverity())) {
            return true;
        }
        return !this.afterDanger;
    }

    private boolean checkRequiredConstraint(Validation validation) {
        ConstraintValidation v;
        if (validation instanceof ConstraintValidation && (v = (ConstraintValidation)validation).getInParametersList() != null) {
            for (AbstractParameter inParam : v.getInParametersList()) {
                if (inParam.getRequired() == null || !inParam.getRequired().booleanValue() || !v.getRequiredFields().contains(inParam.getId()) || this.dataSet.containsKey((Object)inParam.getId())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUsed(Validation v) {
        return !this.usedValidations.contains(v.getId());
    }

    private boolean checkUnique(Validation v) {
        return v.isForField() ? !this.validatedFields.contains(v.getFieldId()) : this.widgetWasValidated == false;
    }

    private boolean checkEnabled(Validation v) {
        if (v.getEnabled() != null) {
            return v.getEnabled();
        }
        if (v.getEnablingConditions() != null) {
            for (String enablingCondition : v.getEnablingConditions()) {
                if (ScriptProcessor.evalForBoolean((String)enablingCondition, (DataSet)this.dataSet)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkMoment(Validation validation) {
        return validation.getMoment() == null || this.moment == null || this.moment == validation.getMoment();
    }

    public static Builder newBuilder() {
        return new Validator().new Builder();
    }

    @Override
    public Iterator<Validation> iterator() {
        return this.validationList.iterator();
    }

    public class Builder {
        private Builder() {
        }

        public Builder addMoment(N2oValidation.ServerMomentEnum moment) {
            Validator.this.moment = moment;
            return this;
        }

        public Builder addValidations(List<Validation> validations) {
            if (validations == null) {
                return this;
            }
            if (Validator.this.validationList == null) {
                Validator.this.validationList = new ArrayList<Validation>();
            }
            Validator.this.validationList.addAll(validations);
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            Validator.this.dataSet = dataSet;
            return this;
        }

        public Builder addInvocationProcessor(InvocationProcessor processor) {
            Validator.this.serviceProvider = processor;
            return this;
        }

        public Builder addDomainProcessor(DomainProcessor processor) {
            Validator.this.domainProcessor = processor;
            return this;
        }

        public Validator build() {
            this.sort();
            return Validator.this;
        }

        private void sort() {
            if (Validator.this.validationList == null) {
                return;
            }
            Comparator<Validation> comparator = Comparator.comparing(Validation::getSeverity).reversed().thenComparing(Validation::isForField).reversed().thenComparing((v1, v2) -> {
                if (v1.getClass() == v2.getClass()) {
                    return 0;
                }
                if (v1.getClass() == MandatoryValidation.class) {
                    return -1;
                }
                if (v1.getClass() == ConditionValidation.class) {
                    if (v2.getClass() == ConstraintValidation.class) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            });
            Validator.this.validationList.sort(comparator);
        }
    }
}

