/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation.engine;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.exception.N2oValidationException;
import net.n2oapp.framework.api.exception.SeverityTypeEnum;
import net.n2oapp.framework.api.exception.ValidationMessage;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.engine.validation.engine.FailInfo;
import net.n2oapp.framework.engine.validation.engine.Validator;
import net.n2oapp.framework.engine.validation.engine.info.ObjectValidationInfo;
import net.n2oapp.framework.engine.validation.engine.info.QueryValidationInfo;

public class ValidationProcessor {
    private InvocationProcessor invocationProcessor;
    private DomainProcessor domainProcessor;

    public ValidationProcessor(InvocationProcessor invocationProcessor) {
        this.invocationProcessor = invocationProcessor;
        this.domainProcessor = new DomainProcessor();
    }

    public ValidationProcessor(InvocationProcessor invocationProcessor, DomainProcessor domainProcessor) {
        this.invocationProcessor = invocationProcessor;
        this.domainProcessor = domainProcessor;
    }

    public List<FailInfo> validate(ObjectValidationInfo info, N2oValidation.ServerMomentEnum moment) {
        Validator validator = this.buildValidator(info, moment);
        return this.collectFails(validator);
    }

    public List<FailInfo> validate(QueryValidationInfo info, N2oValidation.ServerMomentEnum moment) {
        Validator validator = this.buildValidator(info, moment);
        return this.collectFails(validator);
    }

    private List<FailInfo> collectFails(Validator validator) {
        List<FailInfo> fails = validator.validate();
        List<FailInfo> failsWithDanger = this.getFailsWithDanger(fails);
        if (!failsWithDanger.isEmpty()) {
            this.throwDangerException(failsWithDanger);
        }
        return fails;
    }

    private Validator buildValidator(QueryValidationInfo info, N2oValidation.ServerMomentEnum moment) {
        return Validator.newBuilder().addDataSet(info.getDataSet()).addInvocationProcessor(this.invocationProcessor).addDomainProcessor(this.domainProcessor).addValidations(info.getValidations()).addValidations(info.getObject() != null ? info.getObject().getValidations() : null).addMoment(moment).build();
    }

    private Validator buildValidator(ObjectValidationInfo info, N2oValidation.ServerMomentEnum moment) {
        return Validator.newBuilder().addDataSet(info.getDataSet()).addInvocationProcessor(this.invocationProcessor).addDomainProcessor(this.domainProcessor).addValidations(info.getValidations()).addMoment(moment).build();
    }

    private List<FailInfo> getFailsWithDanger(List<FailInfo> fails) {
        return fails.stream().filter(fail -> SeverityTypeEnum.DANGER.equals((Object)fail.getSeverity())).toList();
    }

    private void throwDangerException(List<FailInfo> fails) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String userMessage = null;
        for (FailInfo fail : fails) {
            messages.add(new ValidationMessage(fail.getMessage(), fail.getMessageTitle(), fail.getFieldId(), fail.getValidationId()));
            if (fail.getFieldId() != null) continue;
            userMessage = fail.getMessage();
        }
        throw new N2oValidationException(userMessage, messages);
    }
}

