/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.processing.DataProcessing;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.ui.RequestInfo;
import net.n2oapp.framework.api.ui.ResponseInfo;
import net.n2oapp.framework.api.ui.ResponseMessage;
import net.n2oapp.framework.engine.validation.engine.FailInfo;
import net.n2oapp.framework.engine.validation.engine.ValidationProcessor;
import net.n2oapp.framework.engine.validation.engine.info.ObjectValidationInfo;
import net.n2oapp.framework.engine.validation.engine.info.QueryValidationInfo;

public class N2oValidationModule
implements DataProcessing {
    private ValidationProcessor processor;
    private AlertMessageBuilder alertMessageBuilder;

    public N2oValidationModule(ValidationProcessor processor, AlertMessageBuilder alertMessageBuilder) {
        this.processor = processor;
        this.alertMessageBuilder = alertMessageBuilder;
    }

    public void processAction(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, dataSet), N2oValidation.ServerMomentEnum.BEFORE_OPERATION);
        this.prepareResponse(fails, (RequestInfo)requestInfo, (ResponseInfo)responseInfo);
    }

    public void processActionError(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet, N2oException exception) {
        List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, dataSet), N2oValidation.ServerMomentEnum.AFTER_FAIL_OPERATION);
        this.prepareResponse(fails, (RequestInfo)requestInfo, (ResponseInfo)responseInfo);
        super.processActionError(requestInfo, responseInfo, dataSet, exception);
    }

    public void processActionResult(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, dataSet), N2oValidation.ServerMomentEnum.AFTER_SUCCESS_OPERATION);
        this.prepareResponse(fails, (RequestInfo)requestInfo, (ResponseInfo)responseInfo);
    }

    public void processQueryError(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, N2oException exception) {
        if (requestInfo.isValidationEnable() && requestInfo.getSize() == 1) {
            List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, requestInfo.getData()), N2oValidation.ServerMomentEnum.AFTER_FAIL_QUERY);
            this.prepareResponse(fails, (RequestInfo)requestInfo, (ResponseInfo)responseInfo);
        }
        super.processQueryError(requestInfo, responseInfo, exception);
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        if (requestInfo.isValidationEnable()) {
            List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, requestInfo.getData()), N2oValidation.ServerMomentEnum.BEFORE_QUERY);
            this.prepareResponse(fails, (RequestInfo)requestInfo, (ResponseInfo)responseInfo);
        }
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        List list = page.getCollection();
        if (requestInfo.isValidationEnable() && !list.isEmpty()) {
            List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, (DataSet)list.iterator().next()), N2oValidation.ServerMomentEnum.AFTER_SUCCESS_QUERY);
            this.prepareResponse(fails, (RequestInfo)requestInfo, (ResponseInfo)responseInfo);
        }
    }

    private ObjectValidationInfo buildInfo(ActionRequestInfo<DataSet> requestInfo, DataSet dataSet) {
        return new ObjectValidationInfo(requestInfo.getObject().getId(), requestInfo.getOperation().getValidationList(), dataSet, requestInfo.getMessagesForm());
    }

    private QueryValidationInfo buildInfo(QueryRequestInfo requestInfo, DataSet inDataSet) {
        DataSet dataSet = inDataSet != null ? inDataSet : requestInfo.getData();
        DataSet result = new DataSet();
        Map paramsMap = requestInfo.getQuery().getParamToFilterIdMap();
        for (Map.Entry entry : dataSet.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (paramsMap.containsKey(key)) {
                String mappedKey = (String)paramsMap.get(key);
                if (DataSet.isSpreadKey((String)mappedKey) && !(value instanceof Collection)) {
                    result.put(mappedKey, Collections.singletonList(value));
                    continue;
                }
                result.put(mappedKey, value);
                continue;
            }
            result.put(key, value);
        }
        return new QueryValidationInfo(requestInfo.getQuery().getObject(), requestInfo.getQuery().getValidations(), result, requestInfo.getMessagesForm());
    }

    private void prepareResponse(List<FailInfo> fails, RequestInfo requestInfo, ResponseInfo responseInfo) {
        for (FailInfo fail : fails) {
            ResponseMessage message = responseInfo.constructMessage(requestInfo, fail.getSeverity(), this.alertMessageBuilder);
            message.setText(fail.getMessage());
            message.setTitle(fail.getMessageTitle());
            message.setField(fail.getFieldId());
            responseInfo.addMessage(message);
        }
    }
}

