/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.n2oapp.criteria.dataset.DataList;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.engine.util.MappingProcessor;

public class MapInvocationUtil {
    private static final Predicate<String> MAPPING_PATTERN = Pattern.compile("\\[.+]").asPredicate();
    private static final String KEY_ERROR = "%s -> %s";

    public static Map<String, Object> mapToMap(DataSet dataSet, Map<String, FieldMapping> mapping) {
        MapInvocationUtil.validateMapping(mapping);
        DataSet result = new DataSet();
        for (Map.Entry<String, FieldMapping> entry : mapping.entrySet()) {
            Object value = dataSet.get((Object)entry.getKey());
            if (entry.getValue() != null) {
                String fieldMapping;
                if (!MappingProcessor.isMappingEnabled(entry.getValue().getEnabled(), dataSet)) continue;
                String string = fieldMapping = entry.getValue().getMapping() != null ? entry.getValue().getMapping() : Placeholders.spel((String)entry.getKey());
                if (entry.getValue().getChildMapping() != null && value != null) {
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        DataList list = new DataList();
                        for (Object obj : collection) {
                            list.add(MapInvocationUtil.mapToMap((DataSet)obj, entry.getValue().getChildMapping()));
                        }
                        MappingProcessor.inMap(result, entry.getKey(), fieldMapping, list);
                        continue;
                    }
                    if (!(value instanceof DataSet)) continue;
                    DataSet set = (DataSet)value;
                    MappingProcessor.inMap(result, entry.getKey(), fieldMapping, MapInvocationUtil.mapToMap(set, entry.getValue().getChildMapping()));
                    continue;
                }
                MappingProcessor.inMap(result, entry.getKey(), fieldMapping, value);
                continue;
            }
            MappingProcessor.inMap(result, entry.getKey(), Placeholders.spel((String)entry.getKey()), value);
        }
        return result;
    }

    private static void validateMapping(Map<String, FieldMapping> mapping) {
        String errorMapping = mapping.entrySet().stream().filter(e -> e.getValue() != null && ((FieldMapping)e.getValue()).getMapping() != null).filter(e -> !MAPPING_PATTERN.test(((FieldMapping)e.getValue()).getMapping())).map(e -> String.format(KEY_ERROR, e.getKey(), ((FieldMapping)e.getValue()).getMapping())).collect(Collectors.joining(", "));
        if (!errorMapping.isEmpty()) {
            throw new IllegalArgumentException("Not valid mapping: " + errorMapping);
        }
    }

    @Generated
    private MapInvocationUtil() {
    }
}

