/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import lombok.Generated;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.data.exception.N2oQueryExecutionException;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oRestDataProvider;
import net.n2oapp.framework.api.rest.RestLoggingHandler;
import net.n2oapp.framework.engine.data.QueryUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

public class SpringRestDataProviderEngine
implements MapInvocationEngine<N2oRestDataProvider> {
    private static final Logger log = LoggerFactory.getLogger(SpringRestDataProviderEngine.class);
    private final List<RestLoggingHandler> loggingHandlers;
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;
    private ResponseExtractor<ResponseEntity<Object>> responseExtractor;
    private String baseRestUrl;
    @Value(value="${n2o.engine.rest.forward-headers:}")
    private String forwardHeaders;
    @Value(value="${n2o.engine.rest.forward-cookies:}")
    private String forwardCookies;

    public SpringRestDataProviderEngine(RestTemplate restTemplate, ObjectMapper objectMapper) {
        this(restTemplate, objectMapper, Collections.emptyList());
    }

    public SpringRestDataProviderEngine(RestTemplate restTemplate, ObjectMapper objectMapper, List<RestLoggingHandler> loggingHandlers) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.responseExtractor = new N2oResponseExtractor(objectMapper);
        this.loggingHandlers = loggingHandlers;
    }

    private URI getURI(String host, Integer port, String url, Map<String, Object> args) {
        if (host != null && port != null) {
            url = "http://" + host + ":" + port + (String)url;
        }
        return this.restTemplate.getUriTemplateHandler().expand((String)url, args);
    }

    public Class<? extends N2oRestDataProvider> getType() {
        return N2oRestDataProvider.class;
    }

    public Object invoke(N2oRestDataProvider invocation, Map<String, Object> data) {
        Object query = invocation.getQuery();
        if (query == null) {
            throw new N2oException("query mustn't be null");
        }
        query = ((String)query).trim();
        HttpMethod method = invocation.getMethod() != null ? HttpMethod.valueOf((String)invocation.getMethod().name()) : HttpMethod.GET;
        HashMap<String, Object> args = new HashMap<String, Object>(data);
        if (!((String)query).contains("http")) {
            if (!((String)query).startsWith("/")) {
                query = "/" + (String)query;
            }
            if (((String)query).contains("//")) {
                query = ((String)query).replace("//", "/");
            }
            query = this.baseRestUrl + (String)query;
        }
        String filtersSeparator = invocation.getFiltersSeparator() != null ? invocation.getFiltersSeparator() : "&";
        String sortingSeparator = invocation.getSortingSeparator() != null ? invocation.getSortingSeparator() : "&";
        String joinSeparator = invocation.getJoinSeparator() != null ? invocation.getJoinSeparator() : "&";
        query = QueryUtil.replaceListPlaceholder((String)query, "{select}", args.remove("select"), "", (a, b) -> a + invocation.getSelectSeparator() + b);
        query = QueryUtil.replaceListPlaceholder((String)query, "{filters}", args.remove("filters"), "", str -> this.resolve((String)str, (Map<String, Object>)args, (a, b) -> a + filtersSeparator + b), (a, b) -> a + filtersSeparator + b);
        query = QueryUtil.replaceListPlaceholder((String)query, "{sorting}", args.remove("sorting"), "", (a, b) -> a + sortingSeparator + b);
        query = QueryUtil.replaceListPlaceholder((String)query, "{join}", args.remove("join"), "", (a, b) -> a + joinSeparator + b);
        query = QueryUtil.normalizeQueryParams((String)query);
        return this.executeQuery(method, (String)query, args, invocation);
    }

    protected HttpHeaders initHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        return httpHeaders;
    }

    private Object executeQuery(HttpMethod method, String query, Map<String, Object> args, N2oRestDataProvider invocation) {
        URI finalQuery = this.getURI(invocation.getProxyHost(), invocation.getProxyPort(), query, args);
        HttpHeaders headers = this.initHeaders();
        QueryUtil.copyForwardedHeaders(this.resolveForwardedHeaders(invocation), headers);
        QueryUtil.copyForwardedCookies(this.resolveForwardedCookies(invocation), headers);
        log.debug("Execute REST query: {}", (Object)finalQuery);
        try {
            ResponseEntity<Object> result = switch (method.name()) {
                case "GET" -> this.exchange(finalQuery, method, headers);
                case "DELETE", "POST", "PUT", "PATCH" -> this.exchange(finalQuery, method, args, headers);
                default -> throw new UnsupportedOperationException("Method " + method.name() + " unsupported");
            };
            if (result == null) {
                return null;
            }
            this.loggingHandlers.forEach(handler -> handler.handle(result.getStatusCode().value(), method, finalQuery.toString(), headers));
            return result.getBody();
        }
        catch (RestClientResponseException e) {
            this.loggingHandlers.forEach(handler -> handler.handleError((Exception)((Object)e), method, finalQuery.toString(), headers));
            throw new N2oQueryExecutionException(e.getMessage().replaceAll("[{}]", ""), finalQuery.toString(), (Throwable)e);
        }
    }

    private ResponseEntity<Object> exchange(URI query, HttpMethod method, HttpHeaders headers) {
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)new HttpEntity((MultiValueMap)headers), Object.class);
        return (ResponseEntity)this.restTemplate.execute(query, method, requestCallback, this.responseExtractor);
    }

    private ResponseEntity<Object> exchange(URI query, HttpMethod method, Object body, HttpHeaders headers) {
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)new HttpEntity(body, (MultiValueMap)headers), Object.class);
        return (ResponseEntity)this.restTemplate.execute(query, method, requestCallback, this.responseExtractor);
    }

    private Set<String> resolveForwardedHeaders(N2oRestDataProvider invocation) {
        String headers = invocation.getForwardedHeaders() != null ? invocation.getForwardedHeaders() : this.forwardHeaders;
        return QueryUtil.parseHeadersString(headers);
    }

    private Set<String> resolveForwardedCookies(N2oRestDataProvider invocation) {
        String cookies = invocation.getForwardedCookies() != null ? invocation.getForwardedCookies() : this.forwardCookies;
        return QueryUtil.parseHeadersString(cookies);
    }

    private String resolve(String str, Map<String, Object> args, BinaryOperator<String> reducer) {
        if (!str.contains("{") || !str.contains("}")) {
            return str;
        }
        String paramKey = str.substring(str.indexOf(123) + 1, str.indexOf(125));
        Object object = args.get(paramKey);
        if (!(object instanceof List)) {
            if (args.get(paramKey) == null) {
                return "";
            }
            args.put(paramKey, this.resolveType(str, args.get(paramKey)));
            return str;
        }
        List paramKeyList = (List)object;
        List params = paramKeyList;
        AtomicInteger i = new AtomicInteger();
        Optional<String> result = params.stream().map(item -> {
            if (item == null) {
                return "";
            }
            String newParamKey = paramKey + i.incrementAndGet();
            args.put(newParamKey, this.resolveType(str, item));
            return str.replace(Placeholders.ref((String)paramKey), Placeholders.ref((String)newParamKey));
        }).reduce(reducer);
        return result.orElse("");
    }

    private String resolveType(String target, Object value) {
        String result;
        if (value == null) {
            return target;
        }
        if (value instanceof String || value instanceof Boolean) {
            result = value.toString();
        } else {
            try {
                result = this.objectMapper.writeValueAsString(value).replace("\"", "");
            }
            catch (JsonProcessingException e) {
                throw new N2oException((Throwable)e);
            }
        }
        return result;
    }

    @Generated
    public void setBaseRestUrl(String baseRestUrl) {
        this.baseRestUrl = baseRestUrl;
    }

    @Generated
    public void setForwardHeaders(String forwardHeaders) {
        this.forwardHeaders = forwardHeaders;
    }

    @Generated
    public void setForwardCookies(String forwardCookies) {
        this.forwardCookies = forwardCookies;
    }

    private static class N2oResponseExtractor
    implements ResponseExtractor<ResponseEntity<Object>> {
        private final ObjectMapper mapper;

        public N2oResponseExtractor(ObjectMapper objectMapper) {
            this.mapper = objectMapper;
        }

        public ResponseEntity<Object> extractData(ClientHttpResponse response) throws IOException {
            String result;
            try (InputStream body = response.getBody();){
                result = IOUtils.toString((InputStream)body, (Charset)StandardCharsets.UTF_8);
            }
            Object data = null;
            if (result != null && !result.isEmpty()) {
                data = (result = result.trim()).startsWith("[") ? this.mapper.readValue(result, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, DataSet.class)) : (result.startsWith("{") ? this.mapper.readValue(result, DataSet.class) : this.mapper.readValue(result, Object.class));
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.getStatusCode().value()).headers(response.getHeaders())).body(data);
        }
    }
}

