/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class QueryUtil {
    private static final String AMP_ESCAPE = "&amp;";
    private static final Logger logger = LoggerFactory.getLogger(QueryUtil.class);

    public static String normalizeQueryParams(String query) {
        String q = query;
        if (q.contains(AMP_ESCAPE)) {
            q = q.replace(AMP_ESCAPE, "&");
        }
        if (q.contains("?")) {
            q = q.replaceAll("&+", "&");
            if ((q = q.replace("?&", "?")).endsWith("?")) {
                q = q.substring(0, q.length() - 1);
            }
        }
        return q;
    }

    public static void copyForwardedHeaders(Set<String> forwardedHeaders, HttpHeaders headers) {
        if (CollectionUtils.isEmpty(forwardedHeaders) || Objects.isNull(RequestContextHolder.getRequestAttributes())) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletRequest request = attributes.getRequest();
        logger.info("Forwarded headers for request: {}", (Object)request.getRequestURL());
        if (forwardedHeaders.contains("*")) {
            forwardedHeaders = new HashSet(Collections.list(request.getHeaderNames()));
        }
        for (String forwardedHeaderName : forwardedHeaders) {
            String forwardedHeaderValue = request.getHeader(forwardedHeaderName);
            if (!StringUtils.hasText((String)forwardedHeaderValue)) continue;
            headers.add(forwardedHeaderName, forwardedHeaderValue);
            logger.info("{} : {}", (Object)forwardedHeaderName, (Object)forwardedHeaderValue);
        }
    }

    public static void copyForwardedCookies(Set<String> forwardedCookies, HttpHeaders headers) {
        if (Objects.isNull(RequestContextHolder.getRequestAttributes())) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletRequest request = attributes.getRequest();
        if (CollectionUtils.isEmpty(forwardedCookies) || Objects.isNull(request.getCookies())) {
            return;
        }
        StringJoiner cookieJoiner = new StringJoiner(";");
        if (forwardedCookies.contains("*")) {
            Arrays.stream(request.getCookies()).map(cookie -> String.format("%s=%s", cookie.getName(), cookie.getValue())).forEach(cookieJoiner::add);
        } else {
            for (String forwardedCookieName : forwardedCookies) {
                Arrays.stream(request.getCookies()).filter(cookie -> forwardedCookieName.equals(cookie.getName())).findFirst().map(cookie -> String.format("%s=%s", cookie.getName(), cookie.getValue())).ifPresent(cookieJoiner::add);
            }
        }
        if (cookieJoiner.length() > 0) {
            headers.add("Cookie", cookieJoiner.toString());
            logger.info("Forwarded cookies for request: {} \n {}", (Object)request.getRequestURL(), (Object)cookieJoiner);
        }
    }

    public static Set<String> parseHeadersString(String headers) {
        if (!StringUtils.hasText((String)headers)) {
            return null;
        }
        if (headers.contains("*")) {
            return Set.of("*");
        }
        HashSet<String> result = new HashSet<String>();
        for (String forwardedHeaderName : headers.trim().split(",")) {
            if (!StringUtils.hasText((String)(forwardedHeaderName = forwardedHeaderName.trim()))) continue;
            result.add(forwardedHeaderName);
        }
        return result;
    }

    public static String replacePlaceholders(String baseQuery, Predicate<String> matcher, Function<String, Object> resolver) {
        String[] tokens = baseQuery.split("[ ,&;=?\n]");
        ArrayList<String> placeholders = new ArrayList<String>();
        for (String token : tokens) {
            if (!matcher.test(token)) continue;
            placeholders.add(token);
        }
        for (String placeholder : placeholders) {
            baseQuery = QueryUtil.replacePlaceholder(baseQuery, placeholder, resolver.apply(placeholder), placeholder);
        }
        return baseQuery;
    }

    public static String replacePlaceholder(String baseQuery, String placeholder, Object value, String defaultValue) {
        if (!baseQuery.contains(placeholder)) {
            return baseQuery;
        }
        String clause = defaultValue;
        if (value != null) {
            clause = value.toString();
        }
        return baseQuery.replaceAll(Pattern.quote(placeholder) + "\\b", Matcher.quoteReplacement(clause));
    }

    public static String replaceListPlaceholder(String baseQuery, String placeholder, Object list, String defaultValue, UnaryOperator<String> resolver, BinaryOperator<String> reducer) {
        if (!baseQuery.contains(placeholder)) {
            return baseQuery;
        }
        String clause = defaultValue;
        if (list != null) {
            clause = ((List)list).stream().map(resolver).reduce(reducer).orElse(defaultValue);
        }
        return baseQuery.replace(placeholder, clause);
    }

    public static String replaceListPlaceholder(String baseQuery, String placeholder, Object list, String defaultValue, BinaryOperator<String> reducer) {
        return QueryUtil.replaceListPlaceholder(baseQuery, placeholder, list, defaultValue, s -> s, reducer);
    }

    public static String reduceAnd(String a, String b) {
        return QueryUtil.reduceSeparator(a, b, " AND ");
    }

    public static String reduceComma(String a, String b) {
        return QueryUtil.reduceSeparator(a, b, ", ");
    }

    public static String reduceSpace(String a, String b) {
        return QueryUtil.reduceSeparator(a, b, " ");
    }

    public static String reduceSeparator(String a, String b, String separator) {
        return a + separator + b;
    }

    public static List<String> insertPrefixSuffix(List<String> args, String prefix, String suffix) {
        return args.stream().map(s -> prefix + s + suffix).toList();
    }

    @Generated
    private QueryUtil() {
    }
}

