/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.data.CriteriaConstructor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.invocation.Argument;
import net.n2oapp.framework.api.metadata.global.dao.invocation.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.engine.util.ClassHash;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.apache.commons.lang3.ArrayUtils;

public class ArgumentsInvocationUtil {
    public static Object[] mapToArgs(N2oArgumentsInvocation invocation, CompiledQuery query, N2oPreparedCriteria criteria, CriteriaConstructor criteriaConstructor, DomainProcessor domainProcessor) {
        Object[] argumentInstances = ArgumentsInvocationUtil.instantiateArguments(invocation.getArguments());
        if (ArrayUtils.isEmpty((Object[])argumentInstances)) {
            return new Object[0];
        }
        for (int i = 0; i < invocation.getArguments().length; ++i) {
            if (!Argument.TypeEnum.CRITERIA.equals((Object)invocation.getArguments()[i].getType())) continue;
            argumentInstances[i] = criteriaConstructor.construct(criteria, argumentInstances[i]);
        }
        if (Arrays.stream(invocation.getArguments()).filter(arg -> Argument.TypeEnum.ENTITY.equals((Object)arg.getType()) || Argument.TypeEnum.CRITERIA.equals((Object)arg.getType())).toList().size() > 1) {
            throw new IllegalArgumentException("There must be only one argument with Criteria or Entity type ");
        }
        int idx = 0;
        for (Restriction r : criteria.getRestrictions()) {
            if (r.getValue() != null) {
                N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(r.getFieldId())).get(r.getType());
                String mapping = ArgumentsInvocationUtil.getMapping(invocation.getArguments(), idx, filter.getMapping(), filter.getFilterId());
                MappingProcessor.inMap(argumentInstances, filter.getFilterId(), mapping, r.getValue(), filter.getMapping());
            }
            ++idx;
        }
        ArgumentsInvocationUtil.resolveDefaultValues(invocation.getArguments(), domainProcessor, argumentInstances);
        return argumentInstances;
    }

    public static Object[] mapToArgs(N2oArgumentsInvocation invocation, DataSet dataSet, Map<String, FieldMapping> inMapping, DomainProcessor domainProcessor) {
        if (ArrayUtils.isEmpty((Object[])invocation.getArguments())) {
            return new Object[0];
        }
        Object[] result = ArgumentsInvocationUtil.instantiateArguments(invocation.getArguments());
        int idx = 0;
        for (Map.Entry<String, FieldMapping> entry : inMapping.entrySet()) {
            if (dataSet.get((Object)entry.getKey()) != null) {
                String mapping = ArgumentsInvocationUtil.getMapping(invocation.getArguments(), idx, entry.getValue().getMapping(), entry.getKey());
                MappingProcessor.inMap(result, entry.getKey(), mapping, dataSet.get((Object)entry.getKey()), entry.getValue().getMapping());
            }
            ++idx;
        }
        ArgumentsInvocationUtil.resolveDefaultValues(invocation.getArguments(), domainProcessor, result);
        return result;
    }

    private static String getMapping(Argument[] arguments, int idx, String mapping, String defaultMapping) {
        int argIdx;
        Object resultMapping = mapping != null ? ((argIdx = ArgumentsInvocationUtil.findArgumentPosition(arguments, mapping.substring(1, mapping.indexOf("]")).replace("'", ""))) == -1 ? mapping : "[" + argIdx + "]" + mapping.substring(mapping.indexOf("]") + 1)) : ((argIdx = ArgumentsInvocationUtil.findArgumentPosition(arguments, defaultMapping)) == -1 ? "[" + idx + "]" : "[" + argIdx + "]");
        return resultMapping;
    }

    private static int findArgumentPosition(Argument[] arguments, String name) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!name.equals(arguments[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private static void resolveDefaultValues(Argument[] arguments, DomainProcessor domainProcessor, Object[] results) {
        for (int i = 0; i < results.length; ++i) {
            String defaultValue = arguments[i].getDefaultValue();
            if (results[i] != null || defaultValue == null) continue;
            results[i] = domainProcessor.deserialize((Object)defaultValue);
        }
    }

    private static Object[] instantiateArguments(Argument[] arguments) {
        if (arguments == null) {
            return new Object[0];
        }
        Object[] argumentInstances = new Object[arguments.length];
        for (int k = 0; k < argumentInstances.length; ++k) {
            String className = arguments[k].getClassName();
            if (className == null || arguments[k].getType() == null || Argument.TypeEnum.PRIMITIVE.equals((Object)arguments[k].getType())) {
                argumentInstances[k] = null;
                continue;
            }
            try {
                Class argumentClass = ClassHash.getClass(className);
                argumentInstances[k] = argumentClass.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new N2oException("Can't create instance of class " + className, (Throwable)e);
            }
        }
        return argumentInstances;
    }

    @Generated
    private ArgumentsInvocationUtil() {
    }
}

