/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.normalize;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Optional;
import net.n2oapp.framework.engine.data.normalize.Normalizer;
import org.apache.commons.lang3.StringUtils;

@Normalizer
public class DateFormatNormalizer {
    private static final String DEFAULT_OUTPUT_DATE_FORMAT = "dd.MM.yyyy";
    private static final DateTimeFormatter DEFAULT_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().appendOptional(DateTimeFormatter.ISO_TIME).toFormatter();

    private DateFormatNormalizer() {
        throw new IllegalStateException("Utility class");
    }

    public static String date(String dateStr) {
        return DateFormatNormalizer.dateWithOutput(dateStr, DEFAULT_OUTPUT_DATE_FORMAT);
    }

    public static String dateWithInput(String dateStr, String inputFormat) {
        return DateFormatNormalizer.dateWithInputAndOutput(dateStr, inputFormat, DEFAULT_OUTPUT_DATE_FORMAT);
    }

    public static String dateWithOutput(String dateStr, String outputFormat) {
        if (dateStr == null) {
            return null;
        }
        if (DateFormatNormalizer.isValidDate(dateStr, DEFAULT_FORMATTER)) {
            if (DateFormatNormalizer.hasTime(dateStr, DEFAULT_FORMATTER)) {
                return DateFormatNormalizer.formatDate(LocalDateTime.from(DEFAULT_FORMATTER.parse(dateStr)), outputFormat);
            }
            return DateFormatNormalizer.formatDate(LocalDate.from(DEFAULT_FORMATTER.parse(dateStr)), outputFormat);
        }
        return dateStr;
    }

    public static String dateWithInputAndOutput(String dateStr, String inputFormat, String outputFormat) {
        if (dateStr == null) {
            return null;
        }
        Optional<String> optional = DateFormatNormalizer.formatWithLocalDate(dateStr, inputFormat, outputFormat);
        return optional.orElse(dateStr);
    }

    public static String period(String startDate, String endDate) {
        return StringUtils.join(Arrays.asList(DateFormatNormalizer.date(startDate), DateFormatNormalizer.date(endDate)), (String)" - ");
    }

    private static Optional<String> formatWithLocalDate(String dateStr, String inputFormat, String outputFormat) {
        if (DateFormatNormalizer.isValidDate(dateStr, DateTimeFormatter.ofPattern(inputFormat))) {
            if (DateFormatNormalizer.hasTime(dateStr, DateTimeFormatter.ofPattern(inputFormat))) {
                return Optional.of(DateFormatNormalizer.formatDate(LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(inputFormat)), outputFormat));
            }
            return Optional.of(DateFormatNormalizer.formatDate(LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(inputFormat)), outputFormat));
        }
        return Optional.empty();
    }

    private static boolean isValidDate(String dateStr, DateTimeFormatter formatter) {
        try {
            formatter.parse(dateStr);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            return false;
        }
        return true;
    }

    private static boolean hasTime(String dateStr, DateTimeFormatter pattern) {
        try {
            LocalDateTime.parse(dateStr, pattern);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String formatDate(LocalDate date, String outputFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(outputFormat);
        return date.format(formatter);
    }

    private static String formatDate(LocalDateTime date, String outputFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(outputFormat);
        return date.format(formatter);
    }
}

