/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.NestedList;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.N2oTestDataProvider;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class TestDataProviderEngine
implements MapInvocationEngine<N2oTestDataProvider>,
ResourceLoaderAware {
    private String pathOnDisk;
    private String classpathResourcePath;
    private boolean readonly;
    private final Map<String, List<DataSet>> repository = new ConcurrentHashMap<String, List<DataSet>>();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Map<String, AtomicLong> sequences = new ConcurrentHashMap<String, AtomicLong>();
    private ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public TestDataProviderEngine() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public Class<? extends N2oTestDataProvider> getType() {
        return N2oTestDataProvider.class;
    }

    public Object invoke(N2oTestDataProvider invocation, Map<String, Object> inParams) {
        return this.execute(invocation, inParams, this.getData(invocation));
    }

    public void deleteSessionDataSets(HttpSession session) {
        for (Map.Entry<String, List<DataSet>> entry : this.repository.entrySet()) {
            if (!session.getId().equals(entry.getKey().split("/")[0])) continue;
            this.repository.remove(entry.getKey());
        }
    }

    protected synchronized List<DataSet> getData(N2oTestDataProvider invocation) {
        boolean isInit;
        if (invocation.getFile() == null) {
            return new ArrayList<DataSet>();
        }
        boolean bl = isInit = this.getRepositoryData(invocation.getFile()) == null;
        if (isInit || !this.readonly && this.fileExistsOnDisk(invocation.getFile())) {
            this.initRepository(invocation);
        }
        return this.repository.get(this.richKey(invocation.getFile()));
    }

    protected List<DataSet> getRepositoryData(String key) {
        return this.repository.get(this.richKey(key));
    }

    protected void initRepository(N2oTestDataProvider invocation) {
        try {
            InputStream inputStream = this.getResourceInputStream(invocation);
            List<DataSet> data = this.loadJson(inputStream, invocation.getPrimaryKeyType(), invocation.getPrimaryKey());
            this.repository.put(this.richKey(invocation.getFile()), data);
            if (N2oTestDataProvider.PrimaryKeyType.integer.equals((Object)invocation.getPrimaryKeyType())) {
                long maxId = data.stream().filter(v -> v.get((Object)invocation.getPrimaryKey()) != null).mapToLong(v -> (Long)v.get((Object)invocation.getPrimaryKey())).max().orElse(0L);
                this.sequences.put(this.richKey(invocation.getFile()), new AtomicLong(maxId));
            }
        }
        catch (IOException e) {
            throw new N2oException((Throwable)e);
        }
    }

    protected InputStream getResourceInputStream(N2oTestDataProvider invocation) throws IOException {
        Object path = this.getFullResourcePath(invocation.getFile());
        if (this.fileExistsOnDisk(invocation.getFile())) {
            path = "file:" + this.getFullPathOnDisk(invocation.getFile());
        }
        return this.resourceLoader.getResource((String)path).getInputStream();
    }

    protected String richKey(String key) {
        if (this.classpathResourcePath != null) {
            return this.classpathResourcePath + "/" + key;
        }
        if (this.pathOnDisk != null) {
            return this.pathOnDisk + "/" + key;
        }
        return key;
    }

    protected void updateFile(String filename) {
        if (!this.readonly && this.fileExistsOnDisk(filename)) {
            try (FileWriter fileWriter = new FileWriter(this.getFullPathOnDisk(filename));){
                String mapAsJson = this.objectMapper.writeValueAsString(this.getRepositoryData(filename));
                fileWriter.write(mapAsJson);
            }
            catch (IOException e) {
                throw new N2oException((Throwable)e);
            }
        }
    }

    private Object execute(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        if (invocation.getOperation() == null) {
            return this.findAll(inParams, data);
        }
        switch (invocation.getOperation()) {
            case create: {
                return this.create(invocation, inParams, data);
            }
            case findAll: {
                return this.findAll(inParams, data);
            }
            case findOne: {
                return this.findOne(inParams, data);
            }
            case update: {
                return this.update(invocation, inParams, data);
            }
            case updateMany: {
                return this.updateMany(invocation, inParams, data);
            }
            case updateField: {
                return this.updateField(invocation, inParams, data);
            }
            case delete: {
                return this.delete(invocation, inParams, data);
            }
            case deleteMany: {
                return this.deleteMany(invocation, inParams, data);
            }
            case count: {
                return this.count(inParams, data);
            }
            case echo: {
                return inParams;
            }
        }
        throw new N2oException("Unsupported invocation's operation");
    }

    private List<DataSet> findAll(Map<String, Object> inParams, List<DataSet> data) {
        List sortings = (List)inParams.get("sorting");
        List filters = (List)inParams.get("filters");
        Integer limit = (Integer)inParams.get("limit");
        Integer offset = (Integer)inParams.get("offset");
        Integer count = (Integer)inParams.get("count");
        List<DataSet> modifiableData = new ArrayList<DataSet>(data);
        modifiableData = this.filter(filters, inParams, modifiableData);
        this.sort(sortings, inParams, modifiableData);
        return this.paginate(limit, offset, count, modifiableData);
    }

    private DataSet findOne(Map<String, Object> inParams, List<DataSet> data) {
        List<String> filters = (List<String>)inParams.get("filters");
        if (filters == null) {
            filters = inParams.keySet().stream().map(k -> k + " :eq :" + k).collect(Collectors.toList());
        }
        List<DataSet> modifiableData = new ArrayList<DataSet>(data);
        return (modifiableData = this.filter(filters, inParams, modifiableData)).isEmpty() ? null : modifiableData.get(0);
    }

    private int count(Map<String, Object> inParams, List<DataSet> data) {
        List filters = (List)inParams.get("filters");
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        return this.filter(filters, inParams, modifiableData).size();
    }

    private Object create(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        DataSet newElement = new DataSet();
        newElement.put(invocation.getPrimaryKey(), this.generateKey(invocation.getPrimaryKeyType(), invocation.getFile()));
        this.updateElement((Map)newElement, inParams.entrySet());
        modifiableData.add(0, newElement);
        this.updateRepository(invocation.getFile(), modifiableData);
        this.updateFile(invocation.getFile());
        return newElement;
    }

    private Object update(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get(invocation.getPrimaryKey()) == null) {
            throw new N2oException("Id is required for operation \"update\"");
        }
        DataSet element = modifiableData.stream().filter(TestDataProviderEngine.buildPredicate(invocation.getPrimaryKeyType(), invocation.getPrimaryKey(), inParams)).findFirst().orElseThrow(() -> new N2oException("No such element"));
        this.updateElement((Map)element, inParams.entrySet());
        this.updateRepository(invocation.getFile(), modifiableData);
        this.updateFile(invocation.getFile());
        return element;
    }

    private Object updateMany(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get(invocation.getPrimaryKeys()) == null) {
            throw new N2oException("Ids is required for operation \"updateMany\"");
        }
        List elements = modifiableData.stream().filter(TestDataProviderEngine.buildListPredicate(invocation.getPrimaryKeyType(), invocation.getPrimaryKey(), invocation.getPrimaryKeys(), inParams)).collect(Collectors.toList());
        HashMap<String, Object> fields = new HashMap<String, Object>(inParams);
        fields.remove(invocation.getPrimaryKeys());
        for (DataSet element : elements) {
            this.updateElement((Map)element, fields.entrySet());
        }
        this.updateRepository(invocation.getFile(), modifiableData);
        this.updateFile(invocation.getFile());
        return modifiableData;
    }

    private Object updateField(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get(invocation.getPrimaryKey()) == null) {
            throw new N2oException("Id is required for operation \"updateField\"");
        }
        if (!inParams.containsKey("key") || !inParams.containsKey("value")) {
            throw new N2oException("Should contains parameters \"key\", \"value\" for operation \"updateField\"");
        }
        DataSet element = modifiableData.stream().filter(TestDataProviderEngine.buildPredicate(invocation.getPrimaryKeyType(), invocation.getPrimaryKey(), inParams)).findFirst().orElseThrow(() -> new N2oException("No such element"));
        HashMap<String, Object> fieldData = new HashMap<String, Object>();
        fieldData.put(invocation.getPrimaryKey(), inParams.get(invocation.getPrimaryKey()));
        fieldData.put((String)inParams.get("key"), inParams.get("value"));
        if (inParams.containsKey("key2") && inParams.get("key2") != null) {
            fieldData.put((String)inParams.get("key2"), inParams.get("value2"));
        }
        this.updateElement((Map)element, fieldData.entrySet());
        this.updateRepository(invocation.getFile(), modifiableData);
        this.updateFile(invocation.getFile());
        return null;
    }

    private Object delete(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get(invocation.getPrimaryKey()) == null) {
            throw new N2oException("Id is required for operation \"delete\"");
        }
        modifiableData.removeIf(TestDataProviderEngine.buildPredicate(invocation.getPrimaryKeyType(), invocation.getPrimaryKey(), inParams));
        this.updateRepository(invocation.getFile(), modifiableData);
        this.updateFile(invocation.getFile());
        return null;
    }

    private Object deleteMany(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get(invocation.getPrimaryKeys()) == null) {
            throw new N2oException("Ids is required for operation \"deleteMany\"");
        }
        modifiableData.removeIf(TestDataProviderEngine.buildListPredicate(invocation.getPrimaryKeyType(), invocation.getPrimaryKey(), invocation.getPrimaryKeys(), inParams));
        this.updateRepository(invocation.getFile(), modifiableData);
        this.updateFile(invocation.getFile());
        return null;
    }

    private static Predicate<DataSet> buildPredicate(N2oTestDataProvider.PrimaryKeyType primaryKeyType, String primaryKeyFieldId, Map<String, Object> data) {
        if (N2oTestDataProvider.PrimaryKeyType.integer.equals((Object)primaryKeyType)) {
            return obj -> ((Number)data.get(primaryKeyFieldId)).longValue() == ((Number)obj.get((Object)primaryKeyFieldId)).longValue();
        }
        return obj -> data.get(primaryKeyFieldId).equals(obj.get((Object)primaryKeyFieldId));
    }

    private static Predicate<DataSet> buildListPredicate(N2oTestDataProvider.PrimaryKeyType primaryKeyType, String primaryKeyFieldId, String primaryKeysFieldId, Map<String, Object> data) {
        if (N2oTestDataProvider.PrimaryKeyType.integer.equals((Object)primaryKeyType)) {
            Set list = ((List)data.get(primaryKeysFieldId)).stream().map(o -> ((Number)o).longValue()).collect(Collectors.toSet());
            return obj -> list.contains(((Number)obj.get((Object)primaryKeyFieldId)).longValue());
        }
        return obj -> ((List)data.get(primaryKeysFieldId)).contains(obj.get((Object)primaryKeyFieldId));
    }

    private Object generateKey(N2oTestDataProvider.PrimaryKeyType primaryKeyType, String fileName) {
        if (N2oTestDataProvider.PrimaryKeyType.integer.equals((Object)primaryKeyType)) {
            return this.sequences.get(this.richKey(fileName)).incrementAndGet();
        }
        return UUID.randomUUID().toString();
    }

    private void updateElement(Map element, Set<Map.Entry<String, Object>> fields) {
        for (Map.Entry<String, Object> field : fields) {
            if (field.getValue() instanceof Date) {
                element.put(field.getKey(), new SimpleDateFormat("dd.MM.yyy HH:mm:ss").format(field.getValue()));
                continue;
            }
            element.put(field.getKey(), field.getValue());
        }
    }

    private List<DataSet> paginate(Integer limit, Integer offset, Integer count, List<DataSet> data) {
        Boolean unique = count != null && count.equals(1);
        if (limit != null && offset != null && !unique.booleanValue()) {
            data = data.stream().limit(limit + offset).skip(offset.intValue()).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> filter(List<String> filters, Map<String, Object> inParams, List<DataSet> data) {
        if (filters == null || filters.isEmpty()) {
            if (inParams != null && inParams.containsKey("id")) {
                String id = String.valueOf(inParams.get("id"));
                data = data.stream().filter(m -> m.getId().equals(id)).collect(Collectors.toList());
            }
            return data;
        }
        block26: for (String filter : filters) {
            String[] splittedFilter = filter.replaceAll("[\\s]", "").split(":");
            String field = splittedFilter[0];
            Object pattern = inParams.get(splittedFilter[2]);
            switch (splittedFilter[1]) {
                case "eq": {
                    data = this.eqFilterData(field, pattern, data);
                    continue block26;
                }
                case "notEq": {
                    data = this.notEqFilterData(field, pattern, data);
                    continue block26;
                }
                case "like": {
                    data = this.likeFilterData(field, pattern, data);
                    continue block26;
                }
                case "in": {
                    data = this.inFilterData(field, pattern, data);
                    continue block26;
                }
                case "notIn": {
                    data = this.notInFilterData(field, pattern, data);
                    continue block26;
                }
                case "more": {
                    data = this.moreFilterData(field, pattern, data);
                    continue block26;
                }
                case "less": {
                    data = this.lessFilterData(field, pattern, data);
                    continue block26;
                }
                case "isNull": {
                    data = this.isNullFilterData(field, data);
                    continue block26;
                }
                case "isNotNull": {
                    data = this.isNotNullFilterData(field, data);
                    continue block26;
                }
                case "eqOrIsNull": {
                    data = this.eqOrIsNullFilterData(field, pattern, data);
                    continue block26;
                }
                case "contains": {
                    data = this.containsFilterData(field, pattern, data);
                    continue block26;
                }
            }
            throw new N2oException("Wrong filter type!");
        }
        return data;
    }

    private List<DataSet> eqFilterData(String field, Object pattern, List<DataSet> data) {
        if (pattern != null) {
            data = data.stream().filter(m -> {
                if (!m.containsKey((Object)field) || m.get((Object)field) == null) {
                    return false;
                }
                if (m.get((Object)field) instanceof Number && pattern instanceof Number) {
                    return Long.valueOf(((Number)m.get((Object)field)).longValue()).equals(((Number)pattern).longValue());
                }
                return m.get((Object)field).toString().equals(pattern.toString());
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> notEqFilterData(String field, Object pattern, List<DataSet> data) {
        if (pattern != null) {
            data = data.stream().filter(m -> {
                if (!m.containsKey((Object)field) || m.get((Object)field) == null) {
                    return false;
                }
                if (m.get((Object)field) instanceof Number && pattern instanceof Number) {
                    return !Long.valueOf(((Number)m.get((Object)field)).longValue()).equals(((Number)pattern).longValue());
                }
                return !m.get((Object)field).toString().equals(pattern.toString());
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> likeFilterData(String field, Object pattern, List<DataSet> data) {
        if (pattern != null) {
            data = data.stream().filter(m -> {
                if (!m.containsKey((Object)field) || m.get((Object)field) == null) {
                    return false;
                }
                return m.get((Object)field).toString().toLowerCase().contains(pattern.toString().toLowerCase());
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> inFilterData(String field, Object pattern, List<DataSet> data) {
        List<Object> patterns;
        List<Object> list = patterns = pattern instanceof List ? (List<Object>)pattern : Arrays.asList(pattern);
        if (patterns != null) {
            String[] splittedField = field.split("\\.");
            String parent = splittedField[0];
            String child = splittedField.length > 1 ? splittedField[1] : null;
            data = data.stream().filter(m -> {
                if (child != null) {
                    if (!m.containsKey((Object)parent)) {
                        return false;
                    }
                    if (m.get((Object)parent) instanceof NestedList) {
                        return ((NestedList)m.get((Object)parent)).stream().anyMatch(c -> ((DataSet)c).containsKey((Object)child) && patterns.contains(((DataSet)c).get((Object)child)));
                    }
                    return m.containsKey((Object)field) && patterns.contains(m.get((Object)field));
                }
                if (m.get((Object)field) instanceof Number) {
                    ArrayList longPatterns = new ArrayList();
                    patterns.forEach(p -> longPatterns.add(((Number)p).longValue()));
                    return longPatterns.contains(((Number)m.get((Object)field)).longValue());
                }
                for (Object p2 : patterns) {
                    if (!p2.toString().equals(m.get((Object)field).toString())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> notInFilterData(String field, Object pattern, List<DataSet> data) {
        List<Object> patterns;
        List<Object> list = patterns = pattern instanceof List ? (List<Object>)pattern : Arrays.asList(pattern);
        if (patterns != null) {
            String[] splittedField = field.split("\\.");
            String parent = splittedField[0];
            String child = splittedField.length > 1 ? splittedField[1] : null;
            data = data.stream().filter(m -> {
                if (child != null) {
                    if (!m.containsKey((Object)parent)) {
                        return false;
                    }
                    if (m.get((Object)parent) instanceof NestedList) {
                        return ((NestedList)m.get((Object)parent)).stream().anyMatch(c -> ((DataSet)c).containsKey((Object)child) && !patterns.contains(((DataSet)c).get((Object)child)));
                    }
                    return m.containsKey((Object)field) && !patterns.contains(m.get((Object)field));
                }
                if (m.get((Object)field) instanceof Number) {
                    ArrayList longPatterns = new ArrayList();
                    patterns.forEach(p -> longPatterns.add(((Number)p).longValue()));
                    return !longPatterns.contains(((Number)m.get((Object)field)).longValue());
                }
                return !patterns.contains(m.get((Object)field).toString());
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> containsFilterData(String field, Object pattern, List<DataSet> data) {
        List<Object> patterns;
        List<Object> list = patterns = pattern instanceof List ? (List<Object>)pattern : Collections.singletonList(pattern);
        if (patterns.isEmpty()) {
            return data;
        }
        ArrayList<String> splittedField = new ArrayList<String>(Arrays.asList(field.split("\\.")));
        if (splittedField.size() == 1) {
            return data.stream().filter(m -> {
                if (!m.containsKey(splittedField.get(0)) || !(m.get(splittedField.get(0)) instanceof List)) {
                    return false;
                }
                return m.getList((String)splittedField.get(0)).containsAll(patterns);
            }).collect(Collectors.toList());
        }
        String indexedField = (String)splittedField.remove(splittedField.size() - 1);
        String parentField = String.join((CharSequence)".", splittedField);
        return data.stream().filter(m -> {
            if (!m.containsKey((Object)parentField) || !(m.get((Object)parentField) instanceof List)) {
                return false;
            }
            List mappedData = m.getList(parentField).stream().filter(DataSet.class::isInstance).map(d -> ((DataSet)d).get((Object)indexedField)).collect(Collectors.toList());
            return mappedData.containsAll(patterns);
        }).collect(Collectors.toList());
    }

    private List<DataSet> lessFilterData(String field, Object pattern, List<DataSet> data) {
        if (pattern != null) {
            data = data.stream().filter(m -> {
                if (!m.containsKey((Object)field) || m.get((Object)field) == null) {
                    return false;
                }
                if (m.get((Object)field) instanceof Number && pattern instanceof Number) {
                    return ((Number)m.get((Object)field)).longValue() < ((Number)pattern).longValue();
                }
                if (pattern instanceof LocalDate) {
                    LocalDate date = this.parseToLocalDate(m.get((Object)field).toString());
                    return date.isEqual((ChronoLocalDate)pattern) || date.isBefore((ChronoLocalDate)pattern);
                }
                if (pattern instanceof LocalDateTime) {
                    LocalDateTime dateTime = this.parseToLocalDateTime(m.get((Object)field).toString());
                    return dateTime.isEqual((ChronoLocalDateTime)pattern) || dateTime.isBefore((ChronoLocalDateTime)pattern);
                }
                return m.get((Object)field).toString().compareTo(pattern.toString()) < 0;
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> moreFilterData(String field, Object pattern, List<DataSet> data) {
        if (pattern != null) {
            data = data.stream().filter(m -> {
                if (!m.containsKey((Object)field) || m.get((Object)field) == null) {
                    return false;
                }
                if (m.get((Object)field) instanceof Number && pattern instanceof Number) {
                    return Long.valueOf(((Number)m.get((Object)field)).longValue()).compareTo(((Number)pattern).longValue()) > 0;
                }
                if (pattern instanceof LocalDate) {
                    LocalDate date = this.parseToLocalDate(m.get((Object)field).toString());
                    return date.isEqual((ChronoLocalDate)pattern) || date.isAfter((ChronoLocalDate)pattern);
                }
                if (pattern instanceof LocalDateTime) {
                    LocalDateTime dateTime = this.parseToLocalDateTime(m.get((Object)field).toString());
                    return dateTime.isEqual((ChronoLocalDateTime)pattern) || dateTime.isAfter((ChronoLocalDateTime)pattern);
                }
                return m.get((Object)field).toString().compareTo(pattern.toString()) > 0;
            }).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> isNullFilterData(String field, List<DataSet> data) {
        return data.stream().filter(m -> m.containsKey((Object)field) && m.get((Object)field) == null).collect(Collectors.toList());
    }

    private List<DataSet> isNotNullFilterData(String field, List<DataSet> data) {
        return data.stream().filter(m -> m.containsKey((Object)field) && m.get((Object)field) != null).collect(Collectors.toList());
    }

    private List<DataSet> eqOrIsNullFilterData(String field, Object pattern, List<DataSet> data) {
        if (pattern != null) {
            data = data.stream().filter(m -> {
                if (!m.containsKey((Object)field) || m.containsKey((Object)field) && m.get((Object)field) == null) {
                    return true;
                }
                if (m.get((Object)field) instanceof Number && pattern instanceof Number) {
                    return Long.valueOf(((Number)m.get((Object)field)).longValue()).equals(((Number)pattern).longValue());
                }
                return m.get((Object)field).toString().equals(pattern.toString());
            }).collect(Collectors.toList());
        }
        return data;
    }

    private void sort(List<String> sortings, Map<String, Object> inParams, List<DataSet> data) {
        if (sortings == null || sortings.isEmpty()) {
            return;
        }
        String sorting = sortings.get(0);
        String[] splittedSorting = sorting.replace(" ", "").split(":");
        String direction = (String)inParams.get(splittedSorting[1]);
        if (data.isEmpty()) {
            return;
        }
        Comparator<Object> comparator = Comparator.comparing(m -> (Comparable)((LinkedHashMap)m).get(splittedSorting[0]), Comparator.nullsLast(Comparator.naturalOrder()));
        if (comparator == null) {
            return;
        }
        if (direction.equals("desc")) {
            comparator = comparator.reversed();
        }
        data.sort(comparator);
    }

    private void updateRepository(String key, List<DataSet> newData) {
        this.repository.put(this.richKey(key), newData);
    }

    private List<DataSet> loadJson(InputStream is, N2oTestDataProvider.PrimaryKeyType primaryKeyType, String primaryKeyFieldId) throws IOException {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        CollectionType collectionType = typeFactory.constructCollectionType(List.class, DataSet.class);
        List dataList = (List)this.objectMapper.readValue(is, (JavaType)collectionType);
        for (DataSet data : dataList) {
            if (!data.containsKey((Object)primaryKeyFieldId) || !N2oTestDataProvider.PrimaryKeyType.integer.equals((Object)primaryKeyType)) continue;
            data.put(primaryKeyFieldId, (Object)((Number)data.get((Object)primaryKeyFieldId)).longValue());
        }
        return dataList;
    }

    public String getFullPathOnDisk(String filename) {
        return this.pathOnDisk + this.validateFilename(filename);
    }

    public String getFullResourcePath(String filename) {
        String path = "";
        if (this.classpathResourcePath != null) {
            path = this.classpathResourcePath;
        }
        return "classpath:" + path + this.validateFilename(filename);
    }

    protected String validateFilename(String filename) {
        if (filename != null && !((String)filename).startsWith("/")) {
            filename = "/" + (String)filename;
        }
        return filename;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getPathOnDisk() {
        return this.pathOnDisk;
    }

    public void setPathOnDisk(String pathOnDisk) {
        this.pathOnDisk = pathOnDisk;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public String getClasspathResourcePath() {
        return this.classpathResourcePath;
    }

    public void setClasspathResourcePath(String classpathResourcePath) {
        this.classpathResourcePath = classpathResourcePath;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public Map<String, List<DataSet>> getRepository() {
        return this.repository;
    }

    private boolean fileExistsOnDisk(String filename) {
        return this.pathOnDisk != null && new File(this.getFullPathOnDisk(filename)).isFile();
    }

    private LocalDate parseToLocalDate(String strDate) {
        try {
            return LocalDate.parse(strDate);
        }
        catch (DateTimeParseException e) {
            throw new N2oException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0432 json, \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 ISO_LOCAL_DATE", (Throwable)e);
        }
    }

    private LocalDateTime parseToLocalDateTime(String strDateTime) {
        try {
            ParsePosition pos = new ParsePosition(0);
            TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_ZONED_DATE_TIME.parseUnresolved(strDateTime, pos);
            if (temporalAccessor == null || pos.getErrorIndex() >= 0 || pos.getIndex() < strDateTime.length()) {
                return LocalDateTime.parse(strDateTime);
            }
            return ZonedDateTime.parse(strDateTime).toLocalDateTime();
        }
        catch (DateTimeParseException e) {
            throw new N2oException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b \u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0432 json, \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 ISO_LOCAL_DATE_TIME", (Throwable)e);
        }
    }
}

