/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectListField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.engine.data.normalize.NormalizerCollector;
import net.n2oapp.framework.engine.exception.N2oSpelException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class MappingProcessor {
    private static final ExpressionParser writeParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final ExpressionParser readParser = new SpelExpressionParser(new SpelParserConfiguration(false, false));
    private static final Map<String, Object> registeredFunctions = new HashMap<String, Method>(NormalizerCollector.collect());

    public static void inMap(Object target, String fieldId, String mapping, Object value) {
        MappingProcessor.inMap(target, fieldId, mapping, value, mapping);
    }

    public static void inMap(Object target, String fieldId, String mapping, Object value, String userMapping) {
        try {
            Expression expression = writeParser.parseExpression(mapping);
            if (target != null) {
                expression.setValue(target, value);
            }
        }
        catch (Exception e) {
            throw new N2oSpelException(fieldId, userMapping, e);
        }
    }

    public static <T> T outMap(Object target, String mapping, Class<T> clazz) {
        Object result;
        if (mapping != null) {
            try {
                Expression expression = readParser.parseExpression(mapping);
                result = expression.getValue(target, clazz);
            }
            catch (Exception e) {
                throw new N2oSpelException(mapping, e);
            }
        } else {
            result = target;
        }
        if (clazz != null && result == null) {
            throw new N2oException("Expected is " + String.valueOf(clazz) + ", but actual is null");
        }
        if (clazz != null && !clazz.isAssignableFrom(result.getClass())) {
            throw new N2oException("Expected is " + String.valueOf(clazz) + ", but actual is " + String.valueOf(result.getClass()));
        }
        return (T)result;
    }

    public static void outMap(DataSet target, Object value, String fieldId, String mapping, Object defaultValue, ContextProcessor contextProcessor) {
        try {
            Expression expression = readParser.parseExpression(mapping);
            Object obj = expression.getValue(value);
            target.put(fieldId, obj == null ? contextProcessor.resolve(defaultValue) : obj);
        }
        catch (Exception e) {
            throw new N2oSpelException(fieldId, mapping, e);
        }
    }

    public static void mapParameter(ObjectReferenceField parameter, DataSet dataSet) {
        if (dataSet.containsKey((Object)parameter.getId()) && !MappingProcessor.isMappingEnabled(parameter.getEnabled(), dataSet)) {
            dataSet.remove((Object)parameter.getId());
            return;
        }
        Object data = dataSet.get((Object)parameter.getId());
        if (data == null) {
            return;
        }
        if (parameter.getClass().equals(ObjectReferenceField.class)) {
            dataSet.put(parameter.getId(), MappingProcessor.mapChildParameters(parameter, (DataSet)data));
        } else {
            AbstractCollection collection = parameter instanceof ObjectListField ? new ArrayList() : new HashSet();
            for (Object item : (Collection)data) {
                collection.add(MappingProcessor.mapChildParameters(parameter, (DataSet)item));
            }
            dataSet.put(parameter.getId(), collection);
        }
    }

    public static Object mapChildParameters(ObjectReferenceField parameter, DataSet dataSet) {
        Object instance;
        try {
            instance = Class.forName(parameter.getEntityClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new N2oException((Throwable)e);
        }
        for (AbstractParameter childParam : parameter.getFields()) {
            if (!MappingProcessor.isMappingEnabled(childParam.getEnabled(), dataSet)) {
                dataSet.remove((Object)childParam.getId());
                continue;
            }
            String target = childParam.getMapping() != null ? childParam.getMapping() : childParam.getId();
            try {
                writeParser.parseExpression(target).setValue(instance, dataSet.get((Object)childParam.getId()));
            }
            catch (Exception e) {
                throw new N2oSpelException(childParam.getId(), target, e);
            }
        }
        return instance;
    }

    public static Map<String, FieldMapping> extractFieldMapping(Collection<AbstractParameter> parameters) {
        LinkedHashMap<String, FieldMapping> mappingMap = new LinkedHashMap<String, FieldMapping>();
        if (parameters != null) {
            for (AbstractParameter parameter : parameters) {
                FieldMapping mapping = new FieldMapping(parameter.getMapping());
                mapping.setEnabled(parameter.getEnabled());
                if (parameter instanceof ObjectReferenceField && ((ObjectReferenceField)parameter).getFields() != null) {
                    mapping.setChildMapping(MappingProcessor.extractFieldMapping(Arrays.asList(((ObjectReferenceField)parameter).getFields())));
                }
                mappingMap.put(parameter.getId(), mapping);
            }
        }
        return mappingMap;
    }

    public static Object normalizeValue(Object value, String normalizer, DataSet allData, ExpressionParser parser, BeanFactory beanFactory) {
        return MappingProcessor.normalizeValue(value, normalizer, allData, null, parser, beanFactory);
    }

    public static Object normalizeValue(Object value, String normalizer, DataSet allData, DataSet parentData, ExpressionParser parser, BeanFactory beanFactory) {
        if (normalizer == null) {
            return value;
        }
        StandardEvaluationContext context = new StandardEvaluationContext(value);
        context.setVariables(registeredFunctions);
        if (allData != null) {
            context.setVariable("data", (Object)allData);
        }
        if (parentData != null) {
            context.setVariable("parent", (Object)parentData);
        }
        if (beanFactory != null) {
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        try {
            Expression exp = parser.parseExpression(normalizer);
            return exp.getValue((EvaluationContext)context);
        }
        catch (Exception e) {
            throw new N2oSpelException(normalizer, e);
        }
    }

    public static Boolean resolveCondition(String condition, Map<String, Object> data) {
        StandardEvaluationContext context = new StandardEvaluationContext(data);
        context.setVariables(registeredFunctions);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        try {
            Expression expression = readParser.parseExpression(condition);
            return (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            throw new N2oSpelException(condition, e);
        }
    }

    public static boolean isMappingEnabled(String enabled, DataSet inDataSet) {
        return enabled == null || ScriptProcessor.evalForBoolean((String)enabled, (DataSet)inDataSet);
    }
}

