/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.normalize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.text.MaskFormatter;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.engine.data.normalize.Normalizer;

@Normalizer
public class StringNormalizer {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private StringNormalizer() {
        throw new IllegalStateException("Utility class");
    }

    public static DataSet jsonToMap(String json) {
        try {
            return new DataSet((Map)objectMapper.readValue(json, new TypeReference<Map<? extends String, ?>>(){}));
        }
        catch (JsonProcessingException e) {
            throw new N2oException("Unable to apply function \"#jsonToMap\"", (Throwable)e);
        }
    }

    public static String mapToJson(Object map) {
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new N2oException("Unable to apply function \"#mapToJson\"", (Throwable)e);
        }
    }

    public static String encodeToBase64(String text) {
        return Base64.getUrlEncoder().encodeToString(text.getBytes());
    }

    public static String decodeFromBase64(String base64) {
        return new String(Base64.getUrlDecoder().decode(base64));
    }

    public static String formatByMask(Object value, String mask) {
        try {
            MaskFormatter formatter = new MaskFormatter(mask);
            formatter.setValueContainsLiteralCharacters(false);
            return formatter.valueToString(value);
        }
        catch (ParseException e) {
            throw new N2oException(String.format("Unable to format %s by mask %s", value, mask), (Throwable)e);
        }
    }

    public static String formatFullName(String ... names) {
        return Stream.of(names).map(name -> Objects.requireNonNullElse(name, "")).collect(Collectors.joining(" "));
    }

    public static String formatNameWithInitials(String ... names) {
        return names[0] + (names[1] != null ? String.format(" %s.", Character.valueOf(names[1].toCharArray()[0])) : "") + (names[2] != null ? String.format("%s.", Character.valueOf(names[2].toCharArray()[0])) : "");
    }
}

