/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.Sorting;
import net.n2oapp.criteria.api.SortingDirection;
import net.n2oapp.criteria.dataset.DataList;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.filters.Filter;
import net.n2oapp.criteria.filters.FilterReducer;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.criteria.filters.Result;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.data.ActionInvocationEngine;
import net.n2oapp.framework.api.data.ArgumentsInvocationEngine;
import net.n2oapp.framework.api.data.CriteriaConstructor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.data.QueryExceptionHandler;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.global.dao.invocation.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QueryListField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QueryReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.engine.data.N2oCriteriaConstructor;
import net.n2oapp.framework.engine.data.N2oInvocationFactory;
import net.n2oapp.framework.engine.exception.N2oFoundMoreThanOneRecordException;
import net.n2oapp.framework.engine.exception.N2oRecordNotFoundException;
import net.n2oapp.framework.engine.exception.N2oSpelException;
import net.n2oapp.framework.engine.exception.N2oUniqueRequestNotFoundException;
import net.n2oapp.framework.engine.util.ArgumentsInvocationUtil;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class N2oQueryProcessor
implements QueryProcessor,
MetadataEnvironmentAware,
ApplicationContextAware {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private ContextProcessor contextProcessor;
    private final N2oInvocationFactory invocationFactory;
    private CriteriaConstructor criteriaConstructor = new N2oCriteriaConstructor(false);
    private DomainProcessor domainProcessor;
    private final QueryExceptionHandler exceptionHandler;
    private ApplicationContext applicationContext;
    private boolean pageStartsWith0;
    private String ascExpression;
    private String descExpression;

    public N2oQueryProcessor(N2oInvocationFactory invocationFactory, QueryExceptionHandler exceptionHandler) {
        this.invocationFactory = invocationFactory;
        this.exceptionHandler = exceptionHandler;
    }

    public CollectionPage<DataSet> execute(CompiledQuery query, N2oPreparedCriteria criteria) {
        if (criteria.getSize() == 1) {
            return this.executeOneSizeQuery(query, criteria);
        }
        return this.executePageQuery(this.findListSelection(query, criteria), query, criteria);
    }

    public Integer executeCount(CompiledQuery query, N2oPreparedCriteria criteria) {
        Object result;
        this.resolveRestriction(query, criteria);
        this.addDefaultFilters(query, criteria);
        N2oQuery.Selection selection = this.findCountSelection(query, criteria);
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(selection.getInvocation().getClass());
        if (engine instanceof ArgumentsInvocationEngine) {
            try {
                result = ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)selection.getInvocation(), ArgumentsInvocationUtil.mapToArgs((N2oArgumentsInvocation)selection.getInvocation(), query, criteria, this.criteriaConstructor, this.domainProcessor));
            }
            catch (Exception e) {
                throw this.exceptionHandler.handle(query, criteria, e);
            }
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.prepareMapForQuery(map, selection, query, criteria);
        try {
            result = engine.invoke(selection.getInvocation(), map);
        }
        catch (Exception e) {
            throw this.exceptionHandler.handle(query, criteria, e);
        }
        return this.calculateCount(result, selection.getCountMapping());
    }

    private Integer calculateCount(Object result, String countMapping) {
        try {
            return MappingProcessor.outMap(result, countMapping, Integer.class);
        }
        catch (N2oException e) {
            throw new N2oSpelException(countMapping, e);
        }
    }

    public CollectionPage<DataSet> executeOneSizeQuery(CompiledQuery query, N2oPreparedCriteria criteria) {
        N2oQuery.Selection selection = this.findUniqueSelection(query, criteria);
        if (selection.getType().equals((Object)N2oQuery.Selection.Type.unique)) {
            criteria.setSize(2);
            criteria.setCount(Integer.valueOf(2));
        }
        Object result = this.executeQuery(selection, query, criteria);
        criteria.setSize(1);
        if (selection.getType().equals((Object)N2oQuery.Selection.Type.list)) {
            CollectionPage<DataSet> page = this.preparePageResult(result, query, selection, criteria);
            if (CollectionUtils.isEmpty((Collection)page.getCollection())) {
                throw new N2oRecordNotFoundException();
            }
            if (page.getCollection().size() != 1) {
                throw new N2oFoundMoreThanOneRecordException();
            }
            return page;
        }
        if (selection.getType().equals((Object)N2oQuery.Selection.Type.unique)) {
            DataSet single = this.prepareSingleResult(result, query, selection);
            if (single.isEmpty()) {
                throw new N2oRecordNotFoundException();
            }
            return new CollectionPage(1, Collections.singletonList(single), (Criteria)criteria);
        }
        throw new UnsupportedOperationException();
    }

    private N2oQuery.Selection findCountSelection(CompiledQuery query, N2oPreparedCriteria criteria) {
        Set<String> filterFields = this.getFilterIds(query, criteria);
        N2oQuery.Selection selection = this.chooseSelection(query.getCounts(), filterFields, query.getId());
        if (selection == null) {
            throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d <count> \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0439 \u0434\u043b\u044f \u043f\u0430\u0433\u0438\u043d\u0430\u0446\u0438\u0438", query.getId()));
        }
        return selection;
    }

    private N2oQuery.Selection findUniqueSelection(CompiledQuery query, N2oPreparedCriteria criteria) {
        this.resolveRestriction(query, criteria);
        this.addDefaultFilters(query, criteria);
        Set<String> filterFields = this.getFilterIds(query, criteria);
        N2oQuery.Selection selection = this.chooseSelection(query.getUniques(), filterFields, query.getId());
        if (selection != null) {
            return selection;
        }
        selection = this.chooseSelection(query.getLists(), filterFields, query.getId());
        if (selection == null) {
            throw new N2oUniqueRequestNotFoundException(query.getId());
        }
        return selection;
    }

    private N2oQuery.Selection findListSelection(CompiledQuery query, N2oPreparedCriteria criteria) {
        this.resolveRestriction(query, criteria);
        this.addDefaultFilters(query, criteria);
        Set<String> filterFields = this.getFilterIds(query, criteria);
        N2oQuery.Selection selection = this.chooseSelection(query.getLists(), filterFields, query.getId());
        if (selection == null) {
            throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d <list> \u0437\u0430\u043f\u0440\u043e\u0441", query.getId()));
        }
        return selection;
    }

    private Set<String> getFilterIds(CompiledQuery query, N2oPreparedCriteria criteria) {
        return criteria.getRestrictions() == null ? Collections.emptySet() : criteria.getRestrictions().stream().map(r -> query.getFilterFieldId(r.getFieldId(), r.getType())).collect(Collectors.toSet());
    }

    private Object executeQuery(N2oQuery.Selection selection, CompiledQuery query, N2oPreparedCriteria criteria) {
        Object result;
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(selection.getInvocation().getClass());
        if (engine instanceof ArgumentsInvocationEngine) {
            try {
                result = ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)selection.getInvocation(), ArgumentsInvocationUtil.mapToArgs((N2oArgumentsInvocation)selection.getInvocation(), query, criteria, this.criteriaConstructor, this.domainProcessor));
            }
            catch (Exception e) {
                throw this.exceptionHandler.handle(query, criteria, e);
            }
        } else if (engine instanceof MapInvocationEngine) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            this.prepareMapForQuery(map, selection, query, criteria);
            this.prepareMapForPage(map, criteria, this.pageStartsWith0);
            try {
                result = engine.invoke(selection.getInvocation(), map);
            }
            catch (Exception e) {
                throw this.exceptionHandler.handle(query, criteria, e);
            }
        } else {
            throw new UnsupportedOperationException("InvocationEngine \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d \u043e\u0442 `ArgumentsInvocationEngine` \u0438\u043b\u0438 `MapInvocationEngine`");
        }
        return result;
    }

    private CollectionPage<DataSet> executePageQuery(N2oQuery.Selection selection, CompiledQuery query, N2oPreparedCriteria criteria) {
        if (criteria != null && criteria.getRestrictions() != null) {
            Set restrictionFieldIds = criteria.getRestrictions().stream().map(Restriction::getFieldId).collect(Collectors.toSet());
            for (String fieldId : restrictionFieldIds) {
                if (!this.reduceFiltersByField(criteria, fieldId)) continue;
                return new CollectionPage(0, Collections.emptyList(), (Criteria)criteria);
            }
        }
        Object result = this.executeQuery(selection, query, criteria);
        CollectionPage<DataSet> page = this.preparePageResult(result, query, selection, criteria);
        this.addIdIfNotPresent(query, page);
        return page;
    }

    private boolean reduceFiltersByField(N2oPreparedCriteria criteria, String fieldId) {
        List restrictionsByField = criteria.getRestrictions(fieldId);
        if (restrictionsByField.size() > 1) {
            ArrayList<Filter> resFilters = new ArrayList<Filter>();
            resFilters.add((Filter)restrictionsByField.get(0));
            for (int i = 1; i < restrictionsByField.size(); ++i) {
                boolean notMergeable = false;
                for (Filter result2 : resFilters) {
                    Result reduceResult = FilterReducer.reduce((Filter)result2, (Filter)((Filter)restrictionsByField.get(i)));
                    if (reduceResult.isSuccess()) {
                        resFilters.remove(result2);
                        resFilters.add(reduceResult.getResultFilter());
                        notMergeable = false;
                        break;
                    }
                    if (reduceResult.getType().equals((Object)Result.Type.notMergeable)) {
                        notMergeable = true;
                        continue;
                    }
                    return true;
                }
                if (!notMergeable) continue;
                resFilters.add((Filter)restrictionsByField.get(i));
            }
            criteria.removeFilterForField(fieldId);
            resFilters.forEach(result -> criteria.addRestriction(new Restriction(fieldId, result)));
        }
        return false;
    }

    private void addDefaultFilters(CompiledQuery query, N2oPreparedCriteria criteria) {
        for (Map.Entry entry : query.getFiltersMap().entrySet()) {
            for (N2oQuery.Filter filter : ((Map)entry.getValue()).values()) {
                Object value;
                if (filter.getCompiledDefaultValue() == null || criteria.containsRestriction((String)entry.getKey()) || (value = this.prepareFilterValue(filter.getCompiledDefaultValue(), filter, null)) == null) continue;
                Restriction defaultRestriction = new Restriction((String)entry.getKey(), value, filter.getType());
                criteria.addRestriction(defaultRestriction);
            }
        }
    }

    public void prepareMapForQuery(Map<String, Object> map, N2oQuery.Selection selection, CompiledQuery query, N2oPreparedCriteria criteria) {
        map.put("select", query.getSelectExpressions());
        this.prepareSelectKeys(map, query.getDisplayFields(), query);
        ArrayList<String> where = new ArrayList<String>();
        for (Restriction r : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(r.getFieldId())).get(r.getType());
            if (filter == null) {
                throw new N2oUniqueRequestNotFoundException(query.getId());
            }
            if (filter.getText() != null) {
                where.add(filter.getText());
            }
            MappingProcessor.inMap(map, r.getFieldId(), filter.getMapping(), r.getValue());
        }
        map.put("filters", where);
        ArrayList<String> sortingExp = new ArrayList<String>();
        if (criteria.getSorting() != null) {
            for (Sorting sorting : criteria.getSortings()) {
                QuerySimpleField field = (QuerySimpleField)query.getSimpleFieldsMap().get(sorting.getField());
                if (Boolean.FALSE.equals(field.getIsSorted())) continue;
                sortingExp.add(field.getSortingExpression());
                MappingProcessor.inMap(map, field.getId(), field.getSortingMapping(), this.getSortingDirectionExpression(sorting.getDirection(), selection));
            }
        }
        map.put("sorting", sortingExp);
        if (criteria.getAdditionalFields() != null) {
            criteria.getAdditionalFields().entrySet().stream().filter(es -> Objects.nonNull(es.getValue())).forEach(es -> map.put((String)es.getKey(), es.getValue()));
        }
    }

    private String getSortingDirectionExpression(SortingDirection direction, N2oQuery.Selection selection) {
        if (direction == SortingDirection.ASC) {
            return Objects.requireNonNullElse(selection.getAscExpression(), this.ascExpression);
        }
        return Objects.requireNonNullElse(selection.getDescExpression(), this.descExpression);
    }

    private void prepareSelectKeys(Map<String, Object> map, List<AbstractField> fields, CompiledQuery query) {
        for (AbstractField field : fields) {
            QueryReferenceField referenceField;
            if (!(field instanceof QueryReferenceField) || (referenceField = (QueryReferenceField)field).getSelectKey() == null) continue;
            List displayedInnerFields = query.getDisplayedInnerFields(referenceField);
            map.put(referenceField.getSelectKey(), displayedInnerFields.stream().map(AbstractField::getSelectExpression).collect(Collectors.toList()));
            this.prepareSelectKeys(map, displayedInnerFields, query);
        }
    }

    public void prepareMapForPage(Map<String, Object> map, N2oPreparedCriteria criteria, boolean pageStartsWith0) {
        map.put("limit", criteria.getSize());
        map.put("offset", criteria.getFirst());
        if (criteria.getCount() != null) {
            map.put("count", criteria.getCount());
        }
        map.put("page", pageStartsWith0 ? criteria.getPage() - 1 : criteria.getPage());
    }

    private Object prepareFilterValue(Object value, N2oQuery.Filter filter, DataSet data) {
        Object result = value;
        result = this.contextProcessor.resolve(result);
        result = this.domainProcessor.deserialize(result, filter == null ? null : filter.getDomain());
        result = MappingProcessor.normalizeValue(result, filter == null ? null : filter.getNormalize(), data, parser, (BeanFactory)this.applicationContext);
        return result;
    }

    private DataSet prepareSingleResult(Object res, CompiledQuery query, N2oQuery.Selection selection) {
        Object result;
        try {
            result = MappingProcessor.outMap(res, selection.getResultMapping(), Object.class);
        }
        catch (N2oException e) {
            throw new N2oRecordNotFoundException(e);
        }
        result = MappingProcessor.normalizeValue(result, selection.getResultNormalize(), null, parser, (BeanFactory)this.applicationContext);
        return this.mapFields(result, query.getDisplayFields(), null);
    }

    private CollectionPage<DataSet> preparePageResult(Object res, CompiledQuery query, N2oQuery.Selection selection, N2oPreparedCriteria criteria) {
        CollectionPage collectionPage;
        Object additionalInfo = null;
        if (selection.getAdditionalMapping() != null) {
            additionalInfo = MappingProcessor.outMap(res, selection.getAdditionalMapping(), Object.class);
        }
        Collection result = MappingProcessor.outMap(res, selection.getResultMapping(), Collection.class);
        try {
            result = (Collection)MappingProcessor.normalizeValue(result, selection.getResultNormalize(), null, parser, (BeanFactory)this.applicationContext);
        }
        catch (ClassCastException e) {
            throw new N2oException("\u0412 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0447\u0435\u0440\u0435\u0437 `result-normalize` \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0430\u0441\u044c \u043d\u0435 \u043a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f");
        }
        List<DataSet> content = result.stream().map(obj -> this.mapFields(obj, query.getDisplayFields(), null)).collect(Collectors.toList());
        if (Boolean.FALSE.equals(criteria.getWithCount())) {
            Boolean hasNext = this.getNext(content, criteria, selection, query);
            collectionPage = new CollectionPage(hasNext, content, (Criteria)criteria);
        } else {
            int size = this.getSize(content, criteria, () -> {
                if (criteria.getSize() == 1) {
                    return 1;
                }
                if (selection.getCountMapping() == null) {
                    return this.executeCount(query, criteria);
                }
                return this.calculateCount(res, selection.getCountMapping());
            });
            collectionPage = new CollectionPage(size, content, (Criteria)criteria);
        }
        collectionPage.setAdditionalInfo(additionalInfo);
        return collectionPage;
    }

    private N2oQuery.Selection chooseSelection(N2oQuery.Selection[] selections, Set<String> filterFields, String queryId) {
        if (selections == null) {
            return null;
        }
        if (filterFields == null) {
            N2oQuery.Selection result = this.findBaseSelection(selections);
            if (result == null) {
                throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u0431\u0435\u0437 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432", queryId));
            }
            return result;
        }
        return this.findSelectionByFilters(selections, filterFields);
    }

    private N2oQuery.Selection findBaseSelection(N2oQuery.Selection[] lists) {
        for (N2oQuery.Selection selection : lists) {
            if (!ArrayUtils.isEmpty((Object[])selection.getFilters())) continue;
            return selection;
        }
        return null;
    }

    private N2oQuery.Selection findSelectionByFilters(N2oQuery.Selection[] selections, Set<String> filterFields) {
        for (N2oQuery.Selection selection : selections) {
            Set filters;
            if (ArrayUtils.isEmpty((Object[])selection.getFilters()) || !(filters = Arrays.stream(selection.getFilters()).collect(Collectors.toSet())).equals(filterFields)) continue;
            return selection;
        }
        return this.findBaseSelection(selections);
    }

    private void resolveRestriction(CompiledQuery query, N2oPreparedCriteria criteria) {
        HashSet<String> restrictionsForRemove = null;
        DataSet data = new DataSet();
        for (Restriction restriction : criteria.getRestrictions()) {
            data.put(restriction.getFieldId(), restriction.getValue());
        }
        for (Restriction restriction : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(restriction.getFieldId())).get(restriction.getType());
            Object value = this.prepareFilterValue(restriction.getValue(), filter, data);
            if (value != null) {
                restriction.setValue(value);
                continue;
            }
            if (FilterType.Arity.nullary == restriction.getType().arity) {
                restriction.setValue((Object)Boolean.TRUE);
                continue;
            }
            if (restrictionsForRemove == null) {
                restrictionsForRemove = new HashSet<String>();
            }
            restrictionsForRemove.add(restriction.getFieldId());
        }
        if (restrictionsForRemove != null) {
            restrictionsForRemove.forEach(arg_0 -> ((N2oPreparedCriteria)criteria).removeFilterForField(arg_0));
        }
    }

    private void addIdIfNotPresent(CompiledQuery query, CollectionPage<DataSet> collectionPage) {
        if (!query.getSimpleFieldsMap().containsKey("id")) {
            return;
        }
        if (Boolean.TRUE.equals(((AbstractField)query.getFieldsMap().get("id")).getIsSelected())) {
            return;
        }
        int i = 1;
        for (DataSet dataSet : collectionPage.getCollection()) {
            dataSet.put("id", (Object)i++);
        }
    }

    private DataSet mapFields(Object entry, List<AbstractField> fields, DataSet parentData) {
        DataSet resultDataSet = new DataSet();
        fields.forEach(field -> this.mapField((AbstractField)field, resultDataSet, entry));
        fields.forEach(field -> this.normalizeField((AbstractField)field, resultDataSet, parentData));
        fields.forEach(field -> this.processInnerFields((AbstractField)field, resultDataSet, resultDataSet));
        fields.stream().filter(field -> field instanceof QuerySimpleField && ((QuerySimpleField)field).getN2oSwitch() != null).forEach(field -> this.applySwitch(resultDataSet, (QuerySimpleField)field));
        return resultDataSet;
    }

    private void applySwitch(DataSet resultDataSet, QuerySimpleField field) {
        String valueFieldId = field.getN2oSwitch().getValueFieldId();
        String expression = ScriptProcessor.buildSwitchExpression((N2oSwitch)field.getN2oSwitch()).replace("`", "").replace(valueFieldId, String.format("#this.get('%s')", valueFieldId));
        Object resultSwitch = MappingProcessor.normalizeValue(resultDataSet, expression, null, parser, (BeanFactory)this.applicationContext);
        resultDataSet.replace((Object)valueFieldId, resultSwitch);
    }

    private void mapField(AbstractField field, DataSet target, Object entry) {
        if (field instanceof QueryReferenceField) {
            MappingProcessor.outMap(target, entry, field.getId(), field.getMapping(), null, this.contextProcessor);
        } else {
            MappingProcessor.outMap(target, entry, field.getId(), field.getMapping(), ((QuerySimpleField)field).getDefaultValue(), this.contextProcessor);
        }
    }

    private void processInnerFields(AbstractField field, DataSet target, DataSet parentData) {
        if (field instanceof QueryReferenceField) {
            if (field instanceof QueryListField && target.getList(field.getId()) != null) {
                DataList list = new DataList((Collection)target.getList(field.getId()));
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, (Object)this.mapFields(target.getList(field.getId()).get(i), Arrays.asList(((QueryListField)field).getFields()), parentData));
                }
                target.put(field.getId(), (Object)list);
            } else if (target.get((Object)field.getId()) != null) {
                target.put(field.getId(), (Object)this.mapFields(target.get((Object)field.getId()), Arrays.asList(((QueryReferenceField)field).getFields()), parentData));
            }
        }
    }

    private void normalizeField(AbstractField field, DataSet resultDataSet, DataSet parentDataSet) {
        if (field.getNormalize() != null) {
            Object obj = resultDataSet.get((Object)field.getId());
            obj = this.contextProcessor.resolve(obj);
            try {
                resultDataSet.put(field.getId(), MappingProcessor.normalizeValue(obj, field.getNormalize(), resultDataSet, parentDataSet, parser, (BeanFactory)this.applicationContext));
            }
            catch (N2oSpelException e) {
                e.setFieldId(field.getId());
                throw e;
            }
        }
    }

    private Integer getSize(Collection<DataSet> content, N2oPreparedCriteria criteria, IntSupplier totalSupplier) {
        int size = criteria.getFirst() == 0 ? (criteria.getSize() > content.size() ? content.size() : totalSupplier.getAsInt()) : (!content.isEmpty() && criteria.getSize() > content.size() ? criteria.getFirst() + content.size() : totalSupplier.getAsInt());
        return size;
    }

    private Boolean getNext(Collection<DataSet> content, N2oPreparedCriteria criteria, N2oQuery.Selection selection, CompiledQuery query) {
        if (criteria.getSize() <= content.size()) {
            N2oPreparedCriteria nextCriteria = new N2oPreparedCriteria(criteria);
            nextCriteria.setPage(nextCriteria.getPage() + 1);
            Object res = this.executeQuery(selection, query, nextCriteria);
            Collection result = MappingProcessor.outMap(res, selection.getResultMapping(), Collection.class);
            try {
                result = (Collection)MappingProcessor.normalizeValue(result, selection.getResultNormalize(), null, parser, (BeanFactory)this.applicationContext);
            }
            catch (ClassCastException e) {
                throw new N2oException("\u0412 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0447\u0435\u0440\u0435\u0437 `result-normalize` \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0430\u0441\u044c \u043d\u0435 \u043a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f");
            }
            return !result.isEmpty();
        }
        return false;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.contextProcessor = environment.getContextProcessor();
        this.domainProcessor = environment.getDomainProcessor();
    }

    public void setCriteriaConstructor(CriteriaConstructor criteriaConstructor) {
        this.criteriaConstructor = criteriaConstructor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setPageStartsWith0(boolean pageStartsWith0) {
        this.pageStartsWith0 = pageStartsWith0;
    }

    public void setAscExpression(String ascExpression) {
        this.ascExpression = ascExpression;
    }

    public void setDescExpression(String descExpression) {
        this.descExpression = descExpression;
    }
}

