/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.modules.stack;

import java.util.List;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.processing.DataProcessing;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.engine.modules.stack.DataProcessingCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataProcessingStack {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile List<DataProcessing> stack;

    public void processAction(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.process(module -> {
            this.logger.debug("Processing in data-set");
            module.processAction(requestInfo, responseInfo, dataSet);
        });
    }

    public void processActionError(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet, N2oException exception) {
        this.process(module -> {
            this.logger.debug("Processing action error");
            module.processActionError(requestInfo, responseInfo, dataSet, exception);
        });
    }

    public void processActionResult(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.process(module -> {
            this.logger.debug("Processing out data-set");
            module.processActionResult(requestInfo, responseInfo, dataSet);
        });
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        this.process(module -> {
            this.logger.debug("Processing query");
            module.processQuery(requestInfo, responseInfo);
        });
    }

    public void processQueryError(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, N2oException exception) {
        this.process(module -> {
            this.logger.debug("Processing query error");
            module.processQueryError(requestInfo, responseInfo, exception);
        });
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        this.process(module -> {
            this.logger.debug("Processing query-result");
            module.processQueryResult(requestInfo, responseInfo, page);
        });
    }

    private void process(DataProcessingCallback callback) {
        if (this.stack == null) {
            this.stack = this.findModules();
        }
        for (DataProcessing module : this.stack) {
            callback.process(module);
        }
    }

    protected abstract List<DataProcessing> findModules();
}

