/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.normalize;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.n2oapp.framework.engine.SpringApplicationContextProvider;
import net.n2oapp.framework.engine.data.normalize.Normalizer;
import org.springframework.util.StringUtils;

public class NormalizerCollector {
    private static final String PACKAGES_PROPERTY = "n2o.engine.normalizer.packages";

    public static Map<String, Method> collect() {
        HashSet<Method> functions = new HashSet<Method>();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(NormalizerCollector.getPackagesToScan()).enableExternalClasses().scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Normalizer.class)) {
                functions.addAll(NormalizerCollector.filterPublicStaticMethods(Arrays.asList(classInfo.loadClass().getDeclaredMethods())));
            }
            for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(Normalizer.class)) {
                List<Method> annotatedMethods = classInfo.getMethodInfo().filter(methodInfo -> methodInfo.getAnnotationInfo(Normalizer.class) != null).stream().map(MethodInfo::loadClassAndGetMethod).collect(Collectors.toList());
                functions.addAll(NormalizerCollector.filterPublicStaticMethods(annotatedMethods));
            }
        }
        return functions.stream().collect(Collectors.toMap(NormalizerCollector::findAlias, Function.identity()));
    }

    private static String findAlias(Method function) {
        if (Objects.isNull(function.getAnnotation(Normalizer.class))) {
            return function.getName();
        }
        String alias = function.getAnnotation(Normalizer.class).value();
        return !alias.isBlank() ? alias : function.getName();
    }

    private static Set<Method> filterPublicStaticMethods(Collection<Method> methods) {
        return methods.stream().filter(method -> Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())).collect(Collectors.toSet());
    }

    private static String[] getPackagesToScan() {
        String packagesToScanProperty = SpringApplicationContextProvider.getEnvironmentProperty(PACKAGES_PROPERTY);
        if (packagesToScanProperty == null) {
            return new String[0];
        }
        String[] packagesToScan = packagesToScanProperty.trim().split(",");
        HashSet<String> result = new HashSet<String>();
        for (String p : packagesToScan) {
            if (!StringUtils.hasText((String)(p = p.trim()))) continue;
            result.add(p);
        }
        return result.toArray(new String[result.size()]);
    }
}

