/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.ArrayMergeStrategy;
import net.n2oapp.criteria.dataset.DataList;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.data.ActionInvocationEngine;
import net.n2oapp.framework.api.data.ArgumentsInvocationEngine;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectListField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSetField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.engine.data.N2oInvocationFactory;
import net.n2oapp.framework.engine.exception.N2oSpelException;
import net.n2oapp.framework.engine.util.ArgumentsInvocationUtil;
import net.n2oapp.framework.engine.util.MapInvocationUtil;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class N2oInvocationProcessor
implements InvocationProcessor,
MetadataEnvironmentAware,
ApplicationContextAware {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private N2oInvocationFactory invocationFactory;
    private ContextProcessor contextProcessor;
    private DomainProcessor domainProcessor;
    private ApplicationContext applicationContext;

    public N2oInvocationProcessor(N2oInvocationFactory invocationFactory) {
        this.invocationFactory = invocationFactory;
    }

    public DataSet invoke(N2oInvocation invocation, DataSet inDataSet, Collection<AbstractParameter> inParameters, Collection<AbstractParameter> outParameters) {
        Map<String, FieldMapping> inMapping = MappingProcessor.extractFieldMapping(inParameters);
        Map<String, FieldMapping> outMapping = MappingProcessor.extractFieldMapping(outParameters);
        this.prepareInValues(inParameters, inDataSet);
        DataSet resolvedInDataSet = this.resolveInValuesMapping(inParameters, inDataSet);
        DataSet resultDataSet = this.invoke(invocation, resolvedInDataSet, inMapping, outMapping);
        this.resolveOutValues(outParameters, resultDataSet, null);
        inDataSet.merge(resultDataSet, ArrayMergeStrategy.replace, Boolean.valueOf(true));
        return inDataSet;
    }

    private DataSet invoke(N2oInvocation invocation, DataSet inDataSet, Map<String, FieldMapping> inMapping, Map<String, FieldMapping> outMapping) {
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(invocation.getClass());
        Object result = engine instanceof ArgumentsInvocationEngine ? ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)invocation, ArgumentsInvocationUtil.mapToArgs((N2oArgumentsInvocation)invocation, inDataSet, inMapping, this.domainProcessor)) : engine.invoke(invocation, MapInvocationUtil.mapToMap(inDataSet, inMapping));
        if (invocation.getResultMapping() != null) {
            result = MappingProcessor.outMap(result, invocation.getResultMapping(), Object.class);
        }
        if (invocation.getResultNormalize() != null) {
            result = MappingProcessor.normalizeValue(result, invocation.getResultNormalize(), null, parser, (BeanFactory)this.applicationContext);
        }
        return this.extractFields(result, outMapping);
    }

    protected void resolveOutValues(Collection<AbstractParameter> parameters, DataSet resultDataSet, DataSet parentDataSet) {
        if (parameters == null) {
            return;
        }
        for (AbstractParameter parameter : parameters) {
            Object value = resultDataSet.get((Object)parameter.getId());
            if (parameter instanceof ObjectReferenceField) {
                if (value == null) continue;
                ObjectReferenceField referenceField = (ObjectReferenceField)parameter;
                if (value instanceof Collection) {
                    for (Object obj : (Collection)value) {
                        this.resolveOutValues(List.of(referenceField.getFields()), (DataSet)obj, resultDataSet);
                    }
                } else if (value instanceof DataSet) {
                    this.resolveOutValues(List.of(referenceField.getFields()), (DataSet)value, resultDataSet);
                }
                if (parameter.getNormalize() == null) continue;
                value = this.tryToNormalize(value, parameter, resultDataSet, parentDataSet, this.applicationContext);
                resultDataSet.put(parameter.getId(), value);
                continue;
            }
            ObjectSimpleField simpleField = (ObjectSimpleField)parameter;
            this.resolveOutField(simpleField, resultDataSet, parentDataSet, value);
            if (simpleField.getN2oSwitch() == null) continue;
            this.applySwitch(resultDataSet, simpleField);
        }
    }

    private void resolveOutField(ObjectSimpleField simpleField, DataSet resultDataSet, DataSet parentData, Object value) {
        if (value == null && simpleField.getDefaultValue() != null && simpleField.getMapping() == null) {
            value = this.contextProcessor.resolve((Object)simpleField.getDefaultValue());
        }
        if (value != null && simpleField.getNormalize() != null) {
            value = this.tryToNormalize(value, (AbstractParameter)simpleField, resultDataSet, parentData, this.applicationContext);
        }
        resultDataSet.put(simpleField.getId(), value);
    }

    protected DataSet resolveInValuesMapping(Collection<AbstractParameter> invocationParameters, DataSet inDataSet) {
        if (invocationParameters == null || inDataSet == null) {
            return new DataSet();
        }
        return this.normalizeAndMapFields(invocationParameters, inDataSet, null);
    }

    private DataSet normalizeAndMapFields(Collection<AbstractParameter> invocationParameters, DataSet inDataSet, DataSet parentData) {
        DataSet resultDataSet = new DataSet();
        invocationParameters.forEach(parameter -> {
            Object value = inDataSet.get((Object)parameter.getId());
            if (parameter.getNormalize() != null) {
                value = this.tryToNormalize(value, (AbstractParameter)parameter, inDataSet, parentData, this.applicationContext);
            }
            resultDataSet.put(parameter.getId(), value);
        });
        invocationParameters.stream().filter(parameter -> parameter instanceof ObjectReferenceField && ((ObjectReferenceField)parameter).getFields() != null && resultDataSet.get((Object)parameter.getId()) != null).forEach(parameter -> this.normalizeInnerFields((ObjectReferenceField)parameter, resultDataSet));
        invocationParameters.stream().filter(parameter -> parameter instanceof ObjectSimpleField && ((ObjectSimpleField)parameter).getN2oSwitch() != null).forEach(parameter -> this.applySwitch(resultDataSet, (ObjectSimpleField)parameter));
        invocationParameters.stream().filter(parameter -> parameter instanceof ObjectReferenceField && ((ObjectReferenceField)parameter).getFields() != null && ((ObjectReferenceField)parameter).getEntityClass() != null).forEach(parameter -> MappingProcessor.mapParameter((ObjectReferenceField)parameter, resultDataSet));
        return resultDataSet;
    }

    private void applySwitch(DataSet resultDataSet, ObjectSimpleField parameter) {
        String valueFieldId = parameter.getN2oSwitch().getValueFieldId();
        String checkedValue = (String)resultDataSet.get((Object)valueFieldId);
        String resolvedValue = parameter.getN2oSwitch().getResolvedCases().getOrDefault(checkedValue, parameter.getN2oSwitch().getDefaultCase());
        resultDataSet.put(valueFieldId, (Object)resolvedValue);
    }

    private void normalizeInnerFields(ObjectReferenceField field, DataSet dataSet) {
        List<AbstractParameter> innerParams = Arrays.asList(field.getFields());
        if (field instanceof ObjectListField || field instanceof ObjectSetField) {
            DataList list = new DataList((Collection)dataSet.getList(field.getId()));
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)this.normalizeAndMapFields(innerParams, (DataSet)dataSet.getList(field.getId()).get(i), dataSet));
            }
            dataSet.put(field.getId(), (Object)list);
        } else {
            dataSet.put(field.getId(), (Object)this.normalizeAndMapFields(innerParams, dataSet.getDataSet(field.getId()), dataSet));
        }
    }

    private void prepareInValues(Collection<AbstractParameter> parameters, DataSet inDataSet) {
        if (inDataSet == null) {
            return;
        }
        for (AbstractParameter parameter : parameters) {
            Object value;
            if (parameter instanceof ObjectSimpleField) {
                ObjectSimpleField simpleField = (ObjectSimpleField)parameter;
                Object value2 = inDataSet.get((Object)simpleField.getId());
                if (value2 == null) {
                    value2 = simpleField.getDefaultValue();
                }
                value2 = this.contextProcessor.resolve(value2);
                value2 = this.domainProcessor.deserialize(value2, simpleField.getDomain());
                inDataSet.put(simpleField.getId(), value2);
                continue;
            }
            if (!(parameter instanceof ObjectReferenceField) || (value = inDataSet.get((Object)parameter.getId())) == null) continue;
            if (parameter.getClass().equals(ObjectReferenceField.class)) {
                this.prepareComplexInValues(parameter, value, "<reference>");
                continue;
            }
            if (!(value instanceof Collection)) {
                DataList list = new DataList();
                list.add(value);
                inDataSet.put(parameter.getId(), (Object)list);
            }
            for (Object dataSet : (Collection)inDataSet.get((Object)parameter.getId())) {
                this.prepareComplexInValues(parameter, dataSet, "<list>");
            }
        }
    }

    private void prepareComplexInValues(AbstractParameter parameter, Object dataSet, String parameterType) {
        if (!(dataSet instanceof DataSet)) {
            throw new N2oException(String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f '%s' \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441 %s", parameter.getId(), parameterType));
        }
        AbstractParameter[] fields = ((ObjectReferenceField)parameter).getFields();
        if (fields != null) {
            this.prepareInValues(Arrays.asList(fields), (DataSet)dataSet);
        }
    }

    private Object tryToNormalize(Object value, AbstractParameter parameter, DataSet inDataSet, DataSet parentData, ApplicationContext applicationContext) {
        try {
            value = MappingProcessor.normalizeValue(value, parameter.getNormalize(), inDataSet, parentData, parser, (BeanFactory)applicationContext);
        }
        catch (N2oSpelException e) {
            e.setFieldId(parameter.getId());
            throw e;
        }
        return value;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.contextProcessor = environment.getContextProcessor();
        this.domainProcessor = environment.getDomainProcessor();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private DataSet extractFields(Object source, Map<String, FieldMapping> fieldsMapping) {
        DataSet result = new DataSet();
        for (Map.Entry<String, FieldMapping> map : fieldsMapping.entrySet()) {
            String fieldMapping = map.getValue().getMapping() != null ? map.getValue().getMapping() : Placeholders.spel((String)map.getKey());
            MappingProcessor.outMap(result, source, map.getKey(), fieldMapping, null, this.contextProcessor);
            if (map.getValue().getChildMapping() == null) continue;
            Object value = result.get((Object)map.getKey());
            if (value instanceof Collection) {
                DataList list = new DataList();
                for (Object obj : (Collection)value) {
                    list.add((Object)this.extractFields(obj, map.getValue().getChildMapping()));
                }
                result.put(map.getKey(), (Object)list);
                continue;
            }
            if (value == null) continue;
            result.put(map.getKey(), (Object)this.extractFields(value, map.getValue().getChildMapping()));
        }
        return result;
    }
}

