/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.test;

import java.util.Locale;
import java.util.Properties;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.compile.pipeline.N2oEnvironment;
import net.n2oapp.framework.config.metadata.pack.N2oOperationsPack;
import net.n2oapp.framework.config.metadata.pack.N2oSourceTypesPack;
import net.n2oapp.framework.config.selective.CompileInfo;
import net.n2oapp.framework.config.selective.SelectiveMetadataLoader;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import net.n2oapp.framework.config.selective.reader.ReaderFactoryByMap;
import net.n2oapp.framework.config.test.SimplePropertyResolver;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.reader.PropertiesReader;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;

public abstract class N2oTestBase {
    protected N2oApplicationBuilder builder;

    public void setUp() {
        N2oEnvironment environment = new N2oEnvironment();
        environment.setNamespacePersisterFactory(new PersisterFactoryByMap());
        environment.setNamespaceReaderFactory(new ReaderFactoryByMap(environment));
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.addBasenames(new String[]{"n2o_api_messages", "n2o_api_messages", "n2o_config_messages", "test_messages", "messages"});
        messageSource.setDefaultEncoding("UTF-8");
        Locale locale = new Locale("ru");
        LocaleContextHolder.setLocale((Locale)locale);
        environment.setMessageSource(new MessageSourceAccessor((MessageSource)messageSource));
        OverrideProperties n2oProperties = PropertiesReader.getPropertiesFromClasspath((String)"META-INF/n2o.properties");
        OverrideProperties appProperties = PropertiesReader.getPropertiesFromClasspath((String)"application.properties");
        appProperties.setBaseProperties((Properties)n2oProperties);
        environment.setSystemProperties(new SimplePropertyResolver((Properties)appProperties));
        this.builder = new N2oApplicationBuilder(environment);
        this.configure(this.builder);
        CompileInfo.setSourceTypes(this.builder.getEnvironment().getSourceTypeRegister());
    }

    protected void configure(N2oApplicationBuilder builder) {
        builder.packs(new MetadataPack[]{new N2oSourceTypesPack(), new N2oOperationsPack()});
        builder.loaders(new SelectiveMetadataLoader(builder.getEnvironment().getNamespaceReaderFactory()));
    }
}

