/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective;

import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.reader.ElementReaderFactory;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.api.pack.XmlIOBuilder;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import net.n2oapp.framework.config.selective.SelectiveMetadataLoader;
import net.n2oapp.framework.config.selective.SelectiveUtil;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlIOReader
extends SelectiveMetadataLoader
implements XmlIOBuilder<XmlIOReader> {
    private static final Logger logger;
    private static final BiPredicate<String, String> CANONICAL_COMPARATOR;
    private static final XMLOutputter XML_OUTPUTTER;
    private final PersisterFactoryByMap persisterFactory = new PersisterFactoryByMap();
    private final IOProcessor persisterProcessor = new IOProcessorImpl(this.persisterFactory);

    public XmlIOReader(MetadataEnvironment env) {
        super(env);
    }

    public XmlIOReader addIO(NamespaceIO<? extends NamespaceUriAware> io) {
        this.add(io);
        this.persisterFactory.register(io);
        if (io instanceof IOProcessorAware) {
            IOProcessorAware ioProcessorAware = (IOProcessorAware)io;
            ioProcessorAware.setIOProcessor(this.persisterProcessor);
        }
        return this;
    }

    public <T> T read(String source) {
        return (T)SelectiveUtil.read(source, (ElementReaderFactory)this.readerFactory);
    }

    @SafeVarargs
    public final XmlIOReader ios(NamespaceIO<? extends NamespaceUriAware> ... ios) {
        Stream.of(ios).forEach(this::addIO);
        return this;
    }

    @SafeVarargs
    public final XmlIOReader packs(MetadataPack<? super XmlIOReader> ... packs) {
        Stream.of(packs).forEach(p -> p.build((Object)this));
        return this;
    }

    public boolean persistAndCompareWithSample(NamespaceUriAware n2o, String sample) {
        return this.compareWithSample(n2o, sample);
    }

    private boolean compareWithSample(NamespaceUriAware n2o, String sample) {
        return CANONICAL_COMPARATOR.test(this.toString(n2o), sample);
    }

    private String toString(NamespaceUriAware n2o) {
        Element element = this.persisterFactory.produce(n2o.getClass(), n2o.getNamespace()).persist((Object)n2o, n2o.getNamespace());
        return XML_OUTPUTTER.outputString(element);
    }

    static {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        logger = LoggerFactory.getLogger(XmlIOReader.class);
        CANONICAL_COMPARATOR = (s1, s2) -> {
            try {
                Diff diff = XMLUnit.compareXML((String)s1, (String)s2);
                diff.overrideElementQualifier((ElementQualifier)new ElementNameQualifier());
                boolean similar = diff.similar();
                logger.debug("Comparing two xml...\nSource:\n{}\nPersisted:\n{}\nSimilar? {}\nIdentical? {}\n", new Object[]{s2, s1, similar, diff.identical()});
                if (logger.isErrorEnabled()) {
                    logger.debug(diff.toString());
                }
                return similar;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
        XML_OUTPUTTER = new XMLOutputter(Format.getPrettyFormat());
    }
}

