/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective;

import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.metadata.pack.N2oSourceTypesPack;
import net.n2oapp.framework.config.register.OriginEnum;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.XmlInfo;
import net.n2oapp.framework.config.register.scanner.FolderInfoScanner;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.selective.SelectiveMetadataLoader;

public class CompileInfo
extends SourceInfo {
    private static SourceTypeRegister sourceTypes = ((N2oApplicationBuilder)new N2oApplicationBuilder().packs(new MetadataPack[]{new N2oSourceTypesPack()})).getEnvironment().getSourceTypeRegister();
    protected OriginEnum origin = OriginEnum.XML;
    private String path;
    private Class<? extends SourceMetadata> sourceMetadataClass;

    public CompileInfo(XmlInfo info) {
        this.origin = info.getOrigin();
        this.path = info.getLocalPath() != null && !info.getLocalPath().isEmpty() ? info.getLocalPath() : info.getId();
        this.sourceMetadataClass = info.getBaseSourceClass();
    }

    public CompileInfo(String path) {
        this.path = PathUtil.convertPathToClasspathUri(path);
    }

    public CompileInfo(String id, Class<? extends SourceMetadata> metadataSourceClass) {
        this.id = id;
        this.sourceMetadataClass = metadataSourceClass;
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends SourceMetadata> getBaseSourceClass() {
        if (this.sourceMetadataClass != null) {
            return this.sourceMetadataClass;
        }
        if (this.path != null) {
            String type = RegisterUtil.getIdAndPostfix(this.path)[1];
            if (type == null || type.isEmpty()) {
                return null;
            }
            return sourceTypes.get(type).getBaseSourceClass();
        }
        return null;
    }

    @Deprecated
    public Class<? extends SourceMetadata> getSourceMetadataClass() {
        return this.getBaseSourceClass();
    }

    public Class<? extends SourceLoader> getReaderClass() {
        return SelectiveMetadataLoader.class;
    }

    public Class<? extends MetadataScanner> getScannerClass() {
        return FolderInfoScanner.class;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.path != null) {
            return RegisterUtil.getIdAndPostfix(this.path)[0];
        }
        throw new IllegalStateException("Required id or path");
    }

    public String getPostfix() {
        return RegisterUtil.getIdAndPostfix(this.path)[1];
    }

    public void setSourceMetadataClass(Class<? extends SourceMetadata> sourceMetadataClass) {
        this.sourceMetadataClass = sourceMetadataClass;
    }

    public void setOrigin(OriginEnum origin) {
        this.origin = origin;
    }

    public OriginEnum getOrigin() {
        return this.origin;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUri() {
        return this.path;
    }

    public static void setSourceTypes(SourceTypeRegister sourceTypes) {
        CompileInfo.sourceTypes = sourceTypes;
    }
}

