/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.scanner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.scanner.OverrideInfoScanner;
import net.n2oapp.framework.config.register.scanner.XmlInfoScanner;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FolderInfoScanner
implements OverrideInfoScanner<InfoConstructor>,
MetadataEnvironmentAware {
    private final Collection<String> configPaths;
    private SourceTypeRegister sourceTypeRegister;

    public FolderInfoScanner(@Value(value="${n2o.config.path}") String configPath, @Value(value="${n2o.project.path:}") List<String> projectPaths, @Value(value="${n2o.config.ignores}") List<String> ignores, XmlInfoScanner xmlInfoScanner) {
        this.configPaths = PathUtil.getConfigPaths(configPath, projectPaths, xmlInfoScanner.getPattern(), ignores);
    }

    public List<InfoConstructor> scan() {
        ArrayList<String> xmlPattern = new ArrayList<String>();
        for (String s : this.configPaths) {
            String uri = PathUtil.convertRootPathToUrl(s);
            xmlPattern.add(PathUtil.convertUrlToPattern(uri, "xml", "*.*"));
        }
        return RegisterUtil.collectInfo(FileSystemUtil.getNodesByLocationPattern(xmlPattern), n -> RegisterUtil.createFolderInfo(n, this.sourceTypeRegister));
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.sourceTypeRegister = environment.getSourceTypeRegister();
    }
}

